/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.datatypes;

import com.hp.hpl.jena.datatypes.BaseDatatype;
import com.hp.hpl.jena.datatypes.DatatypeFormatException;
import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.datatypes.xsd.impl.XMLLiteralType;
import com.hp.hpl.jena.shared.impl.JenaParameters;
import java.util.HashMap;
import java.util.Iterator;

public class TypeMapper {
    private static TypeMapper theTypeMap = new TypeMapper();
    private HashMap uriToDT = new HashMap();
    private HashMap classToDT = new HashMap();

    public static TypeMapper getInstance() {
        return theTypeMap;
    }

    public RDFDatatype getSafeTypeByName(String uri) {
        RDFDatatype dtype = (RDFDatatype)this.uriToDT.get(uri);
        if (dtype == null) {
            if (uri == null) {
                return null;
            }
            if (JenaParameters.enableSilentAcceptanceOfUnknownDatatypes) {
                dtype = new BaseDatatype(uri);
                this.registerDatatype(dtype);
            } else {
                throw new DatatypeFormatException("Attempted to created typed literal using an unknown datatype - " + uri);
            }
        }
        return dtype;
    }

    public RDFDatatype getTypeByName(String uri) {
        return (RDFDatatype)this.uriToDT.get(uri);
    }

    public RDFDatatype getTypeByValue(Object value) {
        return (RDFDatatype)this.classToDT.get(value.getClass());
    }

    public Iterator listTypes() {
        return this.uriToDT.values().iterator();
    }

    public void registerDatatype(RDFDatatype type) {
        this.uriToDT.put(type.getURI(), type);
        Class jc = type.getJavaClass();
        if (jc != null) {
            this.classToDT.put(jc, type);
        }
    }

    public static void main(String[] args) {
        Iterator iter = theTypeMap.listTypes();
        while (iter.hasNext()) {
            RDFDatatype dt = (RDFDatatype)iter.next();
            System.out.println(" - " + dt);
        }
    }

    static {
        theTypeMap.registerDatatype(XMLLiteralType.theXMLLiteralType);
        XSDDatatype.loadXSDSimpleTypes(theTypeMap);
    }
}

