% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{datasetBinned123}
\alias{datasetBinned123}
\title{Binned dataset suitable for checking \code{\link{FitCorCbm}}; seed = 123}
\format{
A list with 3 elements: \code{$ratings}, \code{$lesions} and \code{$descriptions}; \code{$ratings}
   contain 3 elements, \code{$NL}, \code{$LL} and \code{$LL_IL} as sub-lists; \code{$lesions}
   contain 3 elements, \code{$perCase}, \code{$IDs} and \code{$weights} as sub-lists; \code{$descriptions}
   contain 7 elements, \code{$fileName}, \code{$type}, \code{$name},
   \code{$truthTableStr}, \code{$design}, \code{$modalityID} and \code{$readerID} as sub-lists;
\itemize{
\item{\code{rating$NL}}{, num [1, 1:2, 1:10000, 1], ratings of non-lesion localizations, NLs}
\item{\code{rating$LL}}{, num [1, 1:2, 1:5000, 1], ratings of lesion localizations, LLs}
\item{\code{rating$LL_IL}}{NA, this placeholder is used only for LROC data}
\item{\code{lesions$perCase}}{, int [1:5000], number of lesions per diseased case}
\item{\code{lesions$IDs}}{, num [1:5000, 1] , numeric labels of lesions on diseased cases}
\item{\code{lesions$weights}}{, num [1:5000, 1], weights (or clinical importances) of lesions}
\item{\code{descriptions$fileName}}{, chr, "datasetBinned123", base name of dataset in `data` folder}
\item{\code{descriptions$type}}{, chr "ROC", the data type}
\item{\code{descriptions$name}}{, chr "SIM-CORCBM-SEED-123", the name of the dataset}
\item{\code{descriptions$truthTableStr}}{, NA, truth table structure}
\item{\code{descriptions$design}}{, chr "FCTRL-X-MOD", study design, factorial dataset}
\item{\code{descriptions$modalityID}}{, chr "1", treatment label(s)}
\item{\code{descriptions$readerID}}{, chr [1:2] "1" "2", reader labels}
}
}
\usage{
datasetBinned123
}
\description{
A binned dataset suitable for analysis by \code{\link{FitCorCbm}}. It was generated by
   \link{DfCreateCorCbmDataset} by setting the \code{seed} variable to 123. Note
   the formatting of the data as a single treatment two reader dataset, even though
   the actual pairing might be different, see \code{\link{FitCorCbm}}. The dataset is 
   intentionally large so as to demonstrate the asymptotic convergence of ML estimates, 
   produced by \code{\link{FitCorCbm}}, to the population values. The data was generated
   by the following argument values to \code{\link{DfCreateCorCbmDataset}}: seed = 123, 
   K1 = 5000, K2 = 5000, desiredNumBins = 5, muX = 1.5, muY = 3, alphaX = 0.4, 
   alphaY = 0.7, rhoNor = 0.3, rhoAbn2 = 0.8.
}
\examples{
str(datasetBinned123)

}
\references{
Zhai X, Chakraborty DP (2017). A bivariate contaminated binormal model for robust 
   fitting of proper ROC curves to a pair of correlated, possibly degenerate, 
   ROC datasets. Medical Physics. 44(6):2207--2222.
}
\keyword{datasets}
