/*
 * Decompiled with CFR 0.152.
 */
package it.bancaditalia.oss.sdmx.client;

import it.bancaditalia.oss.sdmx.api.Codelist;
import it.bancaditalia.oss.sdmx.api.DSDIdentifier;
import it.bancaditalia.oss.sdmx.api.DataFlowStructure;
import it.bancaditalia.oss.sdmx.api.Dataflow;
import it.bancaditalia.oss.sdmx.api.Dimension;
import it.bancaditalia.oss.sdmx.api.GenericSDMXClient;
import it.bancaditalia.oss.sdmx.api.PortableDataSet;
import it.bancaditalia.oss.sdmx.api.PortableTimeSeries;
import it.bancaditalia.oss.sdmx.client.Provider;
import it.bancaditalia.oss.sdmx.client.SDMXClientFactory;
import it.bancaditalia.oss.sdmx.util.Configuration;
import it.bancaditalia.oss.sdmx.util.LoginDialog;
import it.bancaditalia.oss.sdmx.util.SdmxException;
import java.awt.Frame;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;

public class SdmxClientHandler {
    protected static Logger logger = Configuration.getSdmxLogger();
    private static final String sourceClass = SdmxClientHandler.class.getSimpleName();
    public static final String LATEST_VERSION = "latest";
    public static final String ALL_AGENCIES = "all";
    private static Map<String, GenericSDMXClient> clients = new Hashtable<String, GenericSDMXClient>();

    public static boolean needsCredentials(String string) throws SdmxException {
        return SdmxClientHandler.getClient(string).needsCredentials();
    }

    public static void setCredentials(String string, String string2, String string3) throws SdmxException {
        SdmxClientHandler.getClient(string, string2, string3);
    }

    public static void setPreferredLanguage(String string) throws SdmxException {
        Configuration.setLang(string);
    }

    public static void addProvider(String string, String string2, boolean bl, boolean bl2, boolean bl3, String string3) throws SdmxException {
        if (string == null || string.trim().isEmpty()) {
            logger.severe("The name of the provider cannot be null: " + string);
            throw new SdmxException("The name of the provider cannot be null: '" + string + "'");
        }
        if (string2 == null || string2.trim().isEmpty()) {
            logger.severe("The enpoint of the provider cannot be null: " + string2);
            throw new SdmxException("The enpoint of the provider cannot be null: '" + string2 + "'");
        }
        try {
            URL uRL = new URL(string2);
            SDMXClientFactory.addProvider(string, uRL, bl, bl2, bl3, string3, false);
        }
        catch (MalformedURLException malformedURLException) {
            logger.severe("Exception. Class: " + malformedURLException.getClass().getName() + " .Message: " + malformedURLException.getMessage());
            logger.log(Level.FINER, "", malformedURLException);
            throw new SdmxException("The URL provided is not valid: '" + string2 + "'");
        }
    }

    public static List<String> getProviders() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Set<String> set = SDMXClientFactory.getProviders().keySet();
        if (set != null) {
            arrayList = new ArrayList<String>(set);
        }
        return arrayList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DataFlowStructure getDataFlowStructure(String string, String string2) throws SdmxException {
        if (string == null || string.trim().isEmpty()) {
            throw new SdmxException("The name of the provider cannot be null: " + string);
        }
        if (string2 == null || string2.trim().isEmpty()) {
            throw new SdmxException("The name of the dataflow cannot be null: " + string2);
        }
        DataFlowStructure dataFlowStructure = null;
        DSDIdentifier dSDIdentifier = SdmxClientHandler.getDSDIdentifier(string, string2);
        if (dSDIdentifier == null) throw new SdmxException("Could not get dataflow '" + string2 + "' in provider: '" + string + "'");
        String string3 = dSDIdentifier.getFullIdentifier();
        Provider provider = SdmxClientHandler.getProvider(string);
        dataFlowStructure = provider.getDSD(string3);
        if (dataFlowStructure != null) return dataFlowStructure;
        logger.finer("DSD for " + dSDIdentifier.getFullIdentifier() + " not cached. Calling Provider.");
        dataFlowStructure = SdmxClientHandler.getClient(string).getDataFlowStructure(dSDIdentifier, false);
        if (dataFlowStructure == null) throw new SdmxException("Could not get structure for '" + string2 + "' in provider: '" + string + "'");
        provider.setDSD(string3, dataFlowStructure);
        return dataFlowStructure;
    }

    public static DSDIdentifier getDSDIdentifier(String string, String string2) throws SdmxException {
        if (string == null || string.trim().isEmpty()) {
            throw new SdmxException("The name of the provider cannot be null: " + string);
        }
        if (string2 == null || string2.trim().isEmpty()) {
            throw new SdmxException("The name of the dataflow cannot be null: " + string2);
        }
        Provider provider = SdmxClientHandler.getProvider(string);
        DSDIdentifier dSDIdentifier = null;
        dSDIdentifier = provider.getDSDIdentifier(string2);
        if (dSDIdentifier == null) {
            logger.finer("DSD identifier for dataflow " + string2 + " not cached. Calling Provider.");
            Dataflow dataflow = SdmxClientHandler.getClient(string).getDataflow(string2, ALL_AGENCIES, LATEST_VERSION);
            if (dataflow != null) {
                provider.setFlow(dataflow);
                dSDIdentifier = dataflow.getDsdIdentifier();
            } else {
                throw new SdmxException("Could not get dataflow '" + string2 + "' in provider: '" + string + "'");
            }
        }
        return dSDIdentifier;
    }

    public static List<Dimension> getDimensions(String string, String string2) throws SdmxException {
        if (string == null || string.trim().isEmpty()) {
            throw new SdmxException("The name of the provider cannot be null: " + string);
        }
        if (string2 == null || string2.trim().isEmpty()) {
            throw new SdmxException("The name of the dataflow cannot be null: " + string2);
        }
        List<Dimension> list = null;
        DataFlowStructure dataFlowStructure = SdmxClientHandler.getDataFlowStructure(string, string2);
        if (dataFlowStructure == null) {
            throw new SdmxException("Could not get structure for '" + string2 + "' in provider: '" + string + "'");
        }
        list = dataFlowStructure.getDimensions();
        return list;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Map<String, String> getCodes(String string, String string2, String string3) throws SdmxException {
        if (string == null || string.trim().isEmpty()) {
            throw new SdmxException("The name of the provider cannot be null: " + string);
        }
        if (string2 == null || string2.trim().isEmpty()) {
            throw new SdmxException("The name of the dataflow cannot be null: " + string2);
        }
        if (string3 == null || string3.trim().isEmpty()) {
            throw new SdmxException("The name of the dimension cannot be null: " + string3);
        }
        Map<String, String> map = null;
        DataFlowStructure dataFlowStructure = SdmxClientHandler.getDataFlowStructure(string, string2);
        Dimension dimension = dataFlowStructure.getDimension(string3);
        if (dimension == null) throw new SdmxException("The dimension: '" + string3 + "' does not exist in dataflow: '" + string2 + "'");
        map = dimension.getCodeList().getCodes();
        if (map != null) return map;
        logger.finer("Codelist for " + string + ", " + string2 + ", " + string3 + " not cached.");
        Codelist codelist = dataFlowStructure.getDimension(string3).getCodeList();
        map = SdmxClientHandler.getClient(string).getCodes(codelist.getId(), codelist.getAgency(), codelist.getVersion());
        if (map == null) throw new SdmxException("Could not get codes for '" + string2 + "' in provider: '" + string + "'");
        codelist.setCodes(map);
        return map;
    }

    public static Dataflow getFlow(String string, String string2) throws SdmxException {
        if (string == null || string.trim().isEmpty()) {
            throw new SdmxException("The name of the provider cannot be null: " + string);
        }
        if (string2 == null || string2.trim().isEmpty()) {
            throw new SdmxException("The name of the dataflow cannot be null: " + string2);
        }
        Provider provider = SdmxClientHandler.getProvider(string);
        Dataflow dataflow = provider.getFlows().get(string2);
        if (dataflow == null) {
            logger.fine("Dataflow " + string2 + " not cached. Calling Provider.");
            dataflow = SdmxClientHandler.getClient(string).getDataflow(string2, ALL_AGENCIES, LATEST_VERSION);
            if (dataflow != null) {
                provider.setFlow(dataflow);
            } else {
                throw new SdmxException("Could not get dataflow '" + string2 + "' in provider: '" + string + "'");
            }
        }
        return dataflow;
    }

    public static Map<String, String> getFlows(String string, String string2) throws SdmxException {
        if (string == null || string.trim().isEmpty()) {
            throw new SdmxException("The name of the provider cannot be null: " + string);
        }
        Map<String, Dataflow> map = null;
        Provider provider = SdmxClientHandler.getProvider(string);
        map = provider.getFlows();
        if (map == null || map.size() == 0 || !provider.isFull()) {
            logger.fine("Flows for " + string + " not cached. Calling Provider.");
            map = SdmxClientHandler.getClient(string).getDataflows();
            if (map != null && map.size() != 0) {
                provider.setFlows(map);
                provider.setFull(true);
            } else {
                throw new SdmxException("Could not get dataflows from provider: '" + string + "'");
            }
        }
        return SdmxClientHandler.filterFlows(map, string2);
    }

    public static PortableDataSet getTimeSeriesTable(String string, String string2, String string3, String string4) throws SdmxException {
        return new PortableDataSet(SdmxClientHandler.getTimeSeries(string, string2, string3, string4, false, null, false));
    }

    public static List<PortableTimeSeries> getTimeSeries(String string, String string2, String string3, String string4) throws SdmxException {
        return SdmxClientHandler.getTimeSeries(string, string2, string3, string4, false, null, false);
    }

    public static List<PortableTimeSeries> getTimeSeriesRevisions(String string, String string2, String string3, String string4, String string5, boolean bl) throws SdmxException {
        return SdmxClientHandler.getTimeSeries(string, string2, string3, string4, false, string5, bl);
    }

    public static List<PortableTimeSeries> getTimeSeriesNames(String string, String string2) throws SdmxException {
        return SdmxClientHandler.getTimeSeries(string, string2, null, null, true, null, false);
    }

    private static List<PortableTimeSeries> getTimeSeries(String string, String string2, String string3, String string4, boolean bl, String string5, boolean bl2) throws SdmxException {
        if (string == null || string.trim().isEmpty()) {
            throw new SdmxException("The name of the provider cannot be null: " + string);
        }
        if (string2 == null || string2.trim().isEmpty()) {
            throw new SdmxException("The tsKey cannot be null: " + string2);
        }
        ArrayList<PortableTimeSeries> arrayList = new ArrayList<PortableTimeSeries>();
        String[] stringArray = string2.trim().split("\\s*;\\s*");
        for (int i = 0; i < stringArray.length; ++i) {
            List<PortableTimeSeries> list = SdmxClientHandler.getSingleTimeSeries(string, stringArray[i], string3, string4, bl, string5, bl2);
            if (list == null) continue;
            arrayList.addAll(list);
        }
        return arrayList;
    }

    public static String getDataURL(String string, String string2, String string3, String string4, boolean bl, String string5, boolean bl2) throws SdmxException {
        if (string == null || string.trim().isEmpty()) {
            throw new SdmxException("The name of the provider cannot be null: " + string);
        }
        if (string2 == null || string2.trim().isEmpty()) {
            throw new SdmxException("The tsKey cannot be null: " + string2);
        }
        String[] stringArray = SdmxClientHandler.extractFlowAndResource(string2);
        String string6 = stringArray[0];
        String string7 = stringArray[1];
        Dataflow dataflow = SdmxClientHandler.getFlow(string, string6);
        String string8 = SdmxClientHandler.getClient(string).buildDataURL(dataflow, string7, string3, string4, bl, string5, bl2);
        return string8;
    }

    private static List<PortableTimeSeries> getSingleTimeSeries(String string, String string2, String string3, String string4, boolean bl, String string5, boolean bl2) throws SdmxException {
        if (string == null || string.trim().isEmpty()) {
            throw new SdmxException("The name of the provider cannot be null: " + string);
        }
        if (string2 == null || string2.trim().isEmpty()) {
            throw new SdmxException("The tsKey cannot be null: " + string2);
        }
        List<PortableTimeSeries> list = null;
        String[] stringArray = SdmxClientHandler.extractFlowAndResource(string2);
        String string6 = stringArray[0];
        String string7 = stringArray[1];
        Dataflow dataflow = SdmxClientHandler.getFlow(string, string6);
        DataFlowStructure dataFlowStructure = SdmxClientHandler.getDataFlowStructure(string, string6);
        list = SdmxClientHandler.getClient(string).getTimeSeries(dataflow, dataFlowStructure, string7, string3, string4, bl, string5, bl2);
        if (list == null || list.size() == 0) {
            throw new SdmxException("The query: " + string2 + " did not match any time series on the provider.");
        }
        return list;
    }

    public static String dumpTimeSeries(String string, String string2, String string3, String string4) throws SdmxException {
        if (string == null || string.trim().isEmpty()) {
            throw new SdmxException("The name of the provider cannot be null: " + string);
        }
        if (string2 == null || string2.trim().isEmpty()) {
            throw new SdmxException("The id cannot be null: " + string2);
        }
        if (!SDMXClientFactory.getProviders().containsKey(string)) {
            throw new SdmxException("The provider : " + string2 + " does not exist.");
        }
        StringBuffer stringBuffer = new StringBuffer("");
        if (!Configuration.isTable()) {
            List<PortableTimeSeries> list = SdmxClientHandler.getTimeSeries(string, string2, string3, string4);
            int n = 0;
            Iterator<PortableTimeSeries> iterator = list.iterator();
            while (iterator.hasNext()) {
                PortableTimeSeries portableTimeSeries = iterator.next();
                stringBuffer.append(";").append(portableTimeSeries.getName());
                int n2 = portableTimeSeries.getObservations().size();
                if (n2 > n) {
                    n = n2;
                }
                if (iterator.hasNext()) {
                    stringBuffer.append(";");
                }
                if (!Configuration.isReverse()) continue;
                portableTimeSeries.reverse();
            }
            stringBuffer.append("\n");
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < list.size(); ++j) {
                    if (i < list.get(j).getObservations().size()) {
                        stringBuffer.append(list.get(j).getTimeSlots().get(i)).append(";");
                        stringBuffer.append(list.get(j).getObservations().get(i));
                    } else {
                        stringBuffer.append(";");
                    }
                    if (j + 1 >= list.size()) continue;
                    stringBuffer.append(";");
                }
                stringBuffer.append("\n");
            }
        } else {
            stringBuffer.append(SdmxClientHandler.getTimeSeriesTable(string, string2, string3, string4).toString());
        }
        return stringBuffer.toString();
    }

    private static Provider getProvider(String string) throws SdmxException {
        if (string == null || string.trim().isEmpty()) {
            throw new SdmxException("The name of the provider cannot be null: " + string);
        }
        Provider provider = SDMXClientFactory.getProviders().get(string);
        if (provider == null) {
            throw new SdmxException("The provider " + string + " does not exist.");
        }
        return provider;
    }

    private static GenericSDMXClient getClient(String string, String string2, String string3) throws SdmxException {
        logger.entering(sourceClass, "getClient");
        if (string == null || string.trim().isEmpty()) {
            throw new SdmxException("The name of the provider cannot be null: " + string);
        }
        GenericSDMXClient genericSDMXClient = clients.get(string);
        if (genericSDMXClient == null) {
            logger.finer("Client for " + string + " does not exist. I will create it.");
            genericSDMXClient = SDMXClientFactory.createClient(string);
            if (genericSDMXClient.needsCredentials()) {
                SdmxClientHandler.handlePassword(genericSDMXClient, string2, string3);
            }
            clients.put(string, genericSDMXClient);
        }
        logger.exiting(sourceClass, "getClient");
        return genericSDMXClient;
    }

    private static GenericSDMXClient getClient(String string) throws SdmxException {
        if (string == null || string.trim().isEmpty()) {
            throw new SdmxException("The name of the provider cannot be null: " + string);
        }
        return SdmxClientHandler.getClient(string, null, null);
    }

    private static void handlePassword(GenericSDMXClient genericSDMXClient, String string, String string2) throws SdmxException {
        if (genericSDMXClient == null) {
            throw new SdmxException("The client cannot be null: " + genericSDMXClient);
        }
        if (genericSDMXClient.needsCredentials()) {
            if (string == null || string2 == null) {
                JFrame jFrame = new JFrame("Authentication");
                jFrame.setDefaultCloseOperation(2);
                LoginDialog loginDialog = new LoginDialog((Frame)jFrame, "Authentication");
                loginDialog.setVisible(true);
                genericSDMXClient.setCredentials(loginDialog.getUsername(), loginDialog.getPassword());
                jFrame.dispose();
            } else {
                genericSDMXClient.setCredentials(string, string2);
            }
        }
    }

    private static Map<String, String> filterFlows(Map<String, Dataflow> map, String string) {
        logger.entering(sourceClass, "filterFlows");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (map != null && map.size() > 0) {
            if (string != null && !string.trim().isEmpty()) {
                string = string.replaceAll("\\*", ".*").replaceAll("\\?", ".");
            }
            for (String string2 : map.keySet()) {
                String string3 = map.get(string2).getDescription();
                if (string != null && !string.trim().isEmpty()) {
                    if (!string2.matches(string) && !string3.matches(string)) continue;
                    hashMap.put(string2, string3);
                    continue;
                }
                hashMap.put(string2, string3);
            }
        }
        logger.exiting(sourceClass, "filterFlows");
        return hashMap;
    }

    private static String[] translateLegacyTSQuery(String string) {
        String[] stringArray = new String[2];
        String string2 = "[.]";
        String[] stringArray2 = string.split(string2, 2);
        if (stringArray2.length == 2) {
            stringArray[0] = stringArray2[0];
            String string3 = stringArray2[1];
            string3 = string3.replace("*", "");
            stringArray[1] = string3 = string3.replace('|', '+');
        } else {
            logger.severe("Error in query string format: '" + string + "'. Could not get dataflow id.");
        }
        return stringArray;
    }

    private static String[] extractFlowAndResource(String string) throws SdmxException {
        String string2;
        String[] stringArray = (string = string.trim()).split(string2 = "[ /]", 2);
        if (stringArray.length != 2 && (stringArray = SdmxClientHandler.translateLegacyTSQuery(string)).length != 2) {
            throw new SdmxException("Malformed time series key: " + string);
        }
        return stringArray;
    }
}

