/*
 * Decompiled with CFR 0.152.
 */
package it.bankitalia.reri.sia.sdmx.client.custom;

import it.bankitalia.reri.sia.sdmx.api.DSDIdentifier;
import it.bankitalia.reri.sia.sdmx.api.DataFlowStructure;
import it.bankitalia.reri.sia.sdmx.api.Dataflow;
import it.bankitalia.reri.sia.sdmx.api.PortableTimeSeries;
import it.bankitalia.reri.sia.sdmx.client.RestSdmxClient;
import it.bankitalia.reri.sia.sdmx.parser.v20.CodelistParser;
import it.bankitalia.reri.sia.sdmx.parser.v20.DataStructureParser;
import it.bankitalia.reri.sia.sdmx.parser.v20.DataflowParser;
import it.bankitalia.reri.sia.sdmx.parser.v20.GenericDataParser;
import it.bankitalia.reri.sia.util.SdmxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class RestSdmx20Client
extends RestSdmxClient {
    public RestSdmx20Client(String string, URL uRL, boolean bl, boolean bl2) {
        super(string, uRL, bl, bl2);
    }

    @Override
    public Map<String, Dataflow> getDataflows() throws SdmxException {
        HashMap<String, Dataflow> hashMap;
        block5: {
            String string = null;
            String string2 = null;
            hashMap = new HashMap<String, Dataflow>();
            string = this.buildFlowQuery(this.wsEndpoint, "ALL", null, null);
            string2 = this.runQuery(string, null);
            if (string2 != null && !string2.isEmpty()) {
                logger.finest(string2);
                try {
                    List<Dataflow> list = DataflowParser.parse(string2);
                    if (list.size() > 0) {
                        hashMap = new HashMap();
                        for (Dataflow dataflow : list) {
                            hashMap.put(dataflow.getId(), dataflow);
                        }
                        break block5;
                    }
                    throw new SdmxException("The query returned zero dataflows");
                }
                catch (Exception exception) {
                    logger.severe("Exception caught parsing results from call to provider " + this.name);
                    logger.log(Level.FINER, "Exception: ", exception);
                    throw new SdmxException("Exception. Class: " + exception.getClass().getName() + " .Message: " + exception.getMessage());
                }
            }
            throw new SdmxException("The query returned an empty result");
        }
        return hashMap;
    }

    @Override
    public Dataflow getDataflow(String string, String string2, String string3) throws SdmxException {
        String string4 = null;
        String string5 = null;
        Dataflow dataflow = null;
        string4 = this.buildFlowQuery(this.wsEndpoint, string, string2, string3);
        string5 = this.runQuery(string4, null);
        if (string5 != null && !string5.isEmpty()) {
            logger.finest(string5);
            try {
                List<Dataflow> list = DataflowParser.parse(string5);
                if (list.size() < 1) {
                    throw new SdmxException("The query returned zero dataflows");
                }
                dataflow = list.get(0);
            }
            catch (Exception exception) {
                logger.severe("Exception caught parsing results from call to provider " + this.name);
                logger.log(Level.FINER, "Exception: ", exception);
                throw new SdmxException("Exception. Class: " + exception.getClass().getName() + " .Message: " + exception.getMessage());
            }
        } else {
            throw new SdmxException("The query returned an empty result");
        }
        return dataflow;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public DataFlowStructure getDataFlowStructure(DSDIdentifier dSDIdentifier) throws SdmxException {
        String string = null;
        String string2 = null;
        DataFlowStructure dataFlowStructure = new DataFlowStructure();
        if (dSDIdentifier == null) throw new SdmxException("Null dsd in input");
        string = this.buildDSDQuery(this.wsEndpoint, dSDIdentifier.getId(), dSDIdentifier.getAgency(), dSDIdentifier.getVersion());
        string2 = this.runQuery(string, null);
        if (string2 == null) throw new SdmxException("The query returned an empty result");
        if (string2.isEmpty()) throw new SdmxException("The query returned an empty result");
        logger.finest(string2);
        try {
            return DataStructureParser.parse(string2).get(0);
        }
        catch (Exception exception) {
            logger.severe("Exception caught parsing results from call to provider " + this.name);
            logger.log(Level.FINER, "Exception: ", exception);
            throw new SdmxException("Exception. Class: " + exception.getClass().getName() + " .Message: " + exception.getMessage());
        }
    }

    @Override
    public Map<String, String> getCodes(String string, String string2, String string3, String string4) throws SdmxException {
        String string5 = null;
        String string6 = null;
        Map<String, String> map = null;
        string5 = this.buildCodelistQuery(this.wsEndpoint, string2, string3, string4);
        string6 = this.runQuery(string5, null);
        if (string6 != null && !string6.isEmpty()) {
            logger.finest(string6);
            try {
                map = CodelistParser.parse(string6);
            }
            catch (Exception exception) {
                logger.severe("Exception caught parsing results from call to provider " + this.name);
                logger.log(Level.FINER, "Exception: ", exception);
                throw new SdmxException("Exception. Class: " + exception.getClass().getName() + " .Message: " + exception.getMessage());
            }
        } else {
            throw new SdmxException("The query returned an empty result");
        }
        return map;
    }

    @Override
    public List<PortableTimeSeries> getTimeSeries(Dataflow dataflow, DataFlowStructure dataFlowStructure, String string, String string2, String string3) throws SdmxException {
        String string4 = null;
        String string5 = null;
        ArrayList<PortableTimeSeries> arrayList = new ArrayList();
        string4 = this.buildDataQuery(this.wsEndpoint, dataflow, string, string2, string3);
        string5 = this.runQuery(string4, null);
        if (string5 != null && !string5.isEmpty()) {
            logger.finest(string5);
            try {
                arrayList = GenericDataParser.parse(string5, dataflow.getId());
            }
            catch (Exception exception) {
                logger.severe("Exception caught parsing results from call to provider " + this.name);
                logger.log(Level.FINER, "Exception: ", exception);
                throw new SdmxException("Exception. Class: " + exception.getClass().getName() + " .Message: " + exception.getMessage());
            }
        } else {
            throw new SdmxException("The query returned an empty result");
        }
        return arrayList;
    }
}

