/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.eco.discrete;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.DataBlockIterator;
import ec.tstoolkit.eco.Ols;
import ec.tstoolkit.eco.RegModel;
import ec.tstoolkit.eco.discrete.DiscreteModelEvaluation;
import ec.tstoolkit.eco.discrete.ICumulativeDistributionFunction;
import ec.tstoolkit.eco.discrete.llFn;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.maths.matrices.SymmetricMatrix;
import ec.tstoolkit.maths.realfunctions.IFunctionMinimizer;
import ec.tstoolkit.maths.realfunctions.riso.LbfgsMinimizer;

public class DiscreteModel {
    private int[] m_y;
    private Matrix m_x;
    private final ICumulativeDistributionFunction m_fn;
    private IFunctionMinimizer minimizer = new LbfgsMinimizer();

    public DiscreteModel(ICumulativeDistributionFunction fn) {
        this.m_fn = fn;
    }

    public DiscreteModelEvaluation process(int[] y, Matrix X) {
        this.m_y = y;
        this.m_x = X;
        double[] c = this.initialize();
        llFn fn = new llFn(this);
        if (this.getMinimizer().minimize(fn, new DiscreteModelEvaluation(this, new DataBlock(c)))) {
            return (DiscreteModelEvaluation)this.getMinimizer().getResult();
        }
        return null;
    }

    public double[] probabilities(DataBlock b) {
        double[] z = new double[this.m_x.getRowsCount()];
        DataBlockIterator rows = this.m_x.rows();
        DataBlock row = rows.getData();
        do {
            double d = row.dot(b);
            z[rows.getPosition()] = this.m_fn.cdf(d);
        } while (rows.next());
        return z;
    }

    public double loglikelihood(DataBlock b) {
        DataBlockIterator rows = this.m_x.rows();
        double ll = 0.0;
        DataBlock row = rows.getData();
        do {
            int y;
            double d;
            double p;
            if (Double.isNaN(p = this.m_fn.cdf(d = row.dot(b)))) {
                p = d < 0.0 ? 0.0 : 1.0;
            }
            if ((y = this.m_y[rows.getPosition()]) != 0) {
                if (p == 0.0) {
                    ll += -999.0;
                    continue;
                }
                if (p == 1.0) continue;
                ll += Math.log(p);
                continue;
            }
            if (p == 1.0) {
                ll += -999.0;
                continue;
            }
            if (p == 0.0) continue;
            ll += Math.log(1.0 - p);
        } while (rows.next());
        return ll;
    }

    public ICumulativeDistributionFunction getCumulativeDistributionFunction() {
        return this.m_fn;
    }

    public double dloglikelihood(DataBlock b, int i) {
        DataBlockIterator rows = this.m_x.rows();
        DataBlock row = rows.getData();
        double dll = 0.0;
        do {
            double d = row.dot(b);
            double p = this.m_fn.cdf(d);
            double dp = this.m_fn.dcdf(d);
            int y = this.m_y[rows.getPosition()];
            if (y != 0) {
                dll += dp * row.get(i) / p;
                continue;
            }
            dll -= dp * row.get(i) / (1.0 - p);
        } while (rows.next());
        return dll;
    }

    public double[] loglikelihoodGradient(DataBlock b) {
        double[] g = new double[b.getLength()];
        DataBlock G = new DataBlock(g);
        DataBlockIterator rows = this.m_x.rows();
        DataBlock row = rows.getData();
        do {
            double d = row.dot(b);
            double p = this.m_fn.cdf(d);
            double dp = this.m_fn.dcdf(d);
            int y = this.m_y[rows.getPosition()];
            if (y != 0) {
                if (p == 0.0) continue;
                G.addAY(dp / p, row);
                continue;
            }
            if (p == 1.0) continue;
            G.addAY(-dp / (1.0 - p), row);
        } while (rows.next());
        return g;
    }

    public Matrix logLikelihoodHessian(DataBlock b) {
        Matrix h = new Matrix(b.getLength(), b.getLength());
        DataBlockIterator rows = this.m_x.rows();
        DataBlock X = rows.getData();
        do {
            Matrix XX = SymmetricMatrix.CCt(X);
            double x = X.dot(b);
            double f = this.m_fn.cdf(x);
            double cf = 1.0 - f;
            double df = this.m_fn.dcdf(x);
            double d2f = this.m_fn.d2cdf(x);
            int y = this.m_y[rows.getPosition()];
            if (y != 0) {
                h.addAY((f * d2f - df * df) / (f * f), XX);
                continue;
            }
            h.addAY(-(cf * d2f + df * df) / (cf * cf), XX);
        } while (rows.next());
        return h;
    }

    public int[] getY() {
        return this.m_y;
    }

    public Matrix getX() {
        return this.m_x;
    }

    protected double[] initialize() {
        double[] y = new double[this.m_y.length];
        for (int i = 0; i < y.length; ++i) {
            y[i] = this.m_y[i];
        }
        Ols ols = new Ols();
        RegModel regmodel = new RegModel();
        regmodel.setY(new DataBlock(y));
        DataBlockIterator cols = this.m_x.columns();
        DataBlock col = cols.getData();
        do {
            regmodel.addX(col.deepClone());
        } while (cols.next());
        ols.process(regmodel);
        return ols.getLikelihood().getB();
    }

    public IFunctionMinimizer getMinimizer() {
        return this.minimizer;
    }

    public void setMinimizer(IFunctionMinimizer minimizer) {
        this.minimizer = minimizer;
    }
}

