/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.eco;

import ec.tstoolkit.eco.ILikelihood;

public class Likelihood
implements ILikelihood {
    private double m_ll;
    private double m_ssqerr;
    private double m_ldet;
    private int m_n;
    private double[] m_res;

    public double AIC(int nparams) {
        return -2.0 * this.m_ll + (double)(2 * nparams);
    }

    public double BIC(int nparams) {
        return -2.0 * this.m_ll + (double)nparams * Math.log(this.m_n);
    }

    public void clear() {
        this.m_ll = 0.0;
        this.m_ssqerr = 0.0;
        this.m_ldet = 0.0;
        this.m_n = 0;
    }

    @Override
    public double getLogDeterminant() {
        return this.m_ldet;
    }

    @Override
    public double getFactor() {
        return Math.exp(this.m_ldet / (double)this.m_n);
    }

    @Override
    public double getLogLikelihood() {
        return this.m_ll;
    }

    @Override
    public int getN() {
        return this.m_n;
    }

    @Override
    public double[] getResiduals() {
        return this.m_res;
    }

    public double getSer() {
        return Math.sqrt(this.m_ssqerr / (double)this.m_n);
    }

    @Override
    public double getSigma() {
        return this.m_ssqerr / (double)this.m_n;
    }

    @Override
    public double getSsqErr() {
        return this.m_ssqerr;
    }

    public void rescale(double factor) {
        if (factor == 1.0) {
            return;
        }
        this.m_ssqerr /= factor * factor;
        this.m_ll += (double)this.m_n * Math.log(factor);
        if (this.m_res != null) {
            int i = 0;
            while (i < this.m_res.length) {
                int n = i++;
                this.m_res[n] = this.m_res[n] / factor;
            }
        }
    }

    public void set(double ssqerr, double ldet, int ndim) {
        this.m_ll = -0.5 * ((double)ndim * Math.log(Math.PI * 2) + (double)ndim * (1.0 + Math.log(ssqerr / (double)ndim)) + ldet);
        this.m_ssqerr = ssqerr;
        this.m_ldet = ldet;
        this.m_n = ndim;
        this.m_res = null;
    }

    public void setRes(double[] e) {
        this.m_res = (double[])(e != null ? (double[])e.clone() : null);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ll=").append(this.getLogLikelihood()).append(System.lineSeparator());
        builder.append("n=").append(this.getN()).append(System.lineSeparator());
        builder.append("ssq=").append(this.getSsqErr()).append(System.lineSeparator());
        builder.append("ldet=").append(this.getLogDeterminant()).append(System.lineSeparator());
        return builder.toString();
    }
}

