/*
 * Decompiled with CFR 0.152.
 */
package ij.process;

import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.awt.Image;
import java.awt.image.ColorModel;

public class TypeConverter {
    private static final int BYTE = 0;
    private static final int SHORT = 1;
    private static final int FLOAT = 2;
    private static final int RGB = 3;
    private ImageProcessor ip;
    private int type;
    boolean doScaling = true;
    int width;
    int height;

    public TypeConverter(ImageProcessor imageProcessor, boolean bl) {
        this.ip = imageProcessor;
        this.doScaling = bl;
        this.type = imageProcessor instanceof ByteProcessor ? 0 : (imageProcessor instanceof ShortProcessor ? 1 : (imageProcessor instanceof FloatProcessor ? 2 : 3));
        this.width = imageProcessor.getWidth();
        this.height = imageProcessor.getHeight();
    }

    public ImageProcessor convertToByte() {
        switch (this.type) {
            case 0: {
                return this.ip;
            }
            case 1: {
                return this.convertShortToByte();
            }
            case 2: {
                return this.convertFloatToByte();
            }
            case 3: {
                return this.convertRGBToByte();
            }
        }
        return null;
    }

    ByteProcessor convertShortToByte() {
        int n = this.width * this.height;
        short[] sArray = (short[])this.ip.getPixels();
        byte[] byArray = new byte[n];
        if (this.doScaling) {
            int n2 = (int)this.ip.getMin();
            int n3 = (int)this.ip.getMax();
            double d = 256.0 / (double)(n3 - n2 + 1);
            for (int i = 0; i < n; ++i) {
                int n4 = (sArray[i] & 0xFFFF) - n2;
                if (n4 < 0) {
                    n4 = 0;
                }
                if ((n4 = (int)((double)n4 * d + 0.5)) > 255) {
                    n4 = 255;
                }
                byArray[i] = (byte)n4;
            }
            return new ByteProcessor(this.width, this.height, byArray, this.ip.getCurrentColorModel());
        }
        for (int i = 0; i < n; ++i) {
            int n5 = sArray[i] & 0xFFFF;
            if (n5 > 255) {
                n5 = 255;
            }
            byArray[i] = (byte)n5;
        }
        return new ByteProcessor(this.width, this.height, byArray, this.ip.getColorModel());
    }

    ByteProcessor convertFloatToByte() {
        if (this.doScaling) {
            Image image = this.ip.createImage();
            return new ByteProcessor(image);
        }
        ByteProcessor byteProcessor = new ByteProcessor(this.width, this.height);
        byteProcessor.setPixels(0, (FloatProcessor)this.ip);
        byteProcessor.setColorModel(this.ip.getColorModel());
        byteProcessor.resetMinAndMax();
        return byteProcessor;
    }

    ByteProcessor convertRGBToByte() {
        int[] nArray = (int[])this.ip.getPixels();
        double[] dArray = ColorProcessor.getWeightingFactors();
        double d = dArray[0];
        double d2 = dArray[1];
        double d3 = dArray[2];
        byte[] byArray = new byte[this.width * this.height];
        for (int i = 0; i < this.width * this.height; ++i) {
            int n = nArray[i];
            int n2 = (n & 0xFF0000) >> 16;
            int n3 = (n & 0xFF00) >> 8;
            int n4 = n & 0xFF;
            byArray[i] = (byte)((double)n2 * d + (double)n3 * d2 + (double)n4 * d3 + 0.5);
        }
        return new ByteProcessor(this.width, this.height, byArray, null);
    }

    public ImageProcessor convertToShort() {
        switch (this.type) {
            case 0: {
                return this.convertByteToShort();
            }
            case 1: {
                return this.ip;
            }
            case 2: {
                return this.convertFloatToShort();
            }
            case 3: {
                this.ip = this.convertRGBToByte();
                return this.convertByteToShort();
            }
        }
        return null;
    }

    ShortProcessor convertByteToShort() {
        if (!(this.ip.isDefaultLut() || this.ip.isColorLut() || this.ip.isInvertedLut())) {
            this.ip = this.convertToRGB();
            this.ip = this.convertRGBToByte();
            return this.convertByteToShort();
        }
        byte[] byArray = (byte[])this.ip.getPixels();
        short[] sArray = new short[this.width * this.height];
        boolean bl = false;
        for (int i = 0; i < this.width * this.height; ++i) {
            sArray[i] = (short)(byArray[i] & 0xFF);
        }
        return new ShortProcessor(this.width, this.height, sArray, this.ip.getColorModel());
    }

    ShortProcessor convertFloatToShort() {
        float[] fArray = (float[])this.ip.getPixels();
        short[] sArray = new short[this.width * this.height];
        double d = this.ip.getMin();
        double d2 = this.ip.getMax();
        double d3 = d2 - d == 0.0 ? 1.0 : 65535.0 / (d2 - d);
        boolean bl = false;
        for (int i = 0; i < this.width * this.height; ++i) {
            double d4 = this.doScaling ? ((double)fArray[i] - d) * d3 : (double)fArray[i];
            if (d4 < 0.0) {
                d4 = 0.0;
            }
            if (d4 > 65535.0) {
                d4 = 65535.0;
            }
            sArray[i] = (short)(d4 + 0.5);
        }
        return new ShortProcessor(this.width, this.height, sArray, this.ip.getColorModel());
    }

    public ImageProcessor convertToFloat(float[] fArray) {
        switch (this.type) {
            case 0: {
                return this.convertByteToFloat(fArray);
            }
            case 1: {
                return this.convertShortToFloat(fArray);
            }
            case 2: {
                return this.ip;
            }
            case 3: {
                this.ip = this.convertRGBToByte();
                return this.convertByteToFloat(null);
            }
        }
        return null;
    }

    FloatProcessor convertByteToFloat(float[] fArray) {
        int n;
        if (!(this.ip.isDefaultLut() || this.ip.isColorLut() || this.ip.isInvertedLut())) {
            this.ip = this.convertToRGB();
            this.ip = this.convertRGBToByte();
            return this.convertByteToFloat(null);
        }
        byte[] byArray = (byte[])this.ip.getPixels();
        float[] fArray2 = new float[this.width * this.height];
        if (fArray != null && fArray.length == 256) {
            for (n = 0; n < this.width * this.height; ++n) {
                fArray2[n] = fArray[byArray[n] & 0xFF];
            }
        } else {
            for (n = 0; n < this.width * this.height; ++n) {
                fArray2[n] = byArray[n] & 0xFF;
            }
        }
        ColorModel colorModel = this.ip.getColorModel();
        return new FloatProcessor(this.width, this.height, fArray2, colorModel);
    }

    FloatProcessor convertShortToFloat(float[] fArray) {
        int n;
        short[] sArray = (short[])this.ip.getPixels();
        float[] fArray2 = new float[this.width * this.height];
        if (fArray != null && fArray.length == 65536) {
            for (n = 0; n < this.width * this.height; ++n) {
                fArray2[n] = fArray[sArray[n] & 0xFFFF];
            }
        } else {
            for (n = 0; n < this.width * this.height; ++n) {
                fArray2[n] = sArray[n] & 0xFFFF;
            }
        }
        ColorModel colorModel = this.ip.getColorModel();
        return new FloatProcessor(this.width, this.height, fArray2, colorModel);
    }

    public ImageProcessor convertToRGB() {
        if (this.type == 3) {
            return this.ip;
        }
        ImageProcessor imageProcessor = this.ip.convertToByte(this.doScaling);
        return new ColorProcessor(imageProcessor.createImage());
    }
}

