/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.io.FileInfo;
import ij.io.OpenDialog;
import ij.plugin.PlugIn;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StreamTokenizer;

public class PGM_Reader
extends ImagePlus
implements PlugIn {
    private int width;
    private int height;
    private boolean rawBits;
    private boolean sixteenBits;
    private boolean isColor;
    private boolean isBlackWhite;
    private int maxValue;

    public void run(String string) {
        ImageStack imageStack;
        OpenDialog openDialog = new OpenDialog("PBM/PGM/PPM Reader...", string);
        String string2 = openDialog.getDirectory();
        String string3 = openDialog.getFileName();
        if (string3 == null) {
            return;
        }
        String string4 = string2 + string3;
        IJ.showStatus("Opening: " + string4);
        try {
            imageStack = this.openFile(string4);
        }
        catch (IOException iOException) {
            String string5 = iOException.getMessage();
            IJ.showMessage("PBM/PGM/PPM Reader", string5.equals("") ? "" + iOException : string5);
            return;
        }
        this.setStack(string3, imageStack);
        FileInfo fileInfo = new FileInfo();
        fileInfo.fileFormat = 8;
        fileInfo.directory = string2;
        fileInfo.fileName = string3;
        this.setFileInfo(fileInfo);
        if (string.equals("")) {
            this.show();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImageStack openFile(String string) throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
        try {
            Object object;
            StreamTokenizer streamTokenizer = new StreamTokenizer(bufferedInputStream);
            streamTokenizer.resetSyntax();
            streamTokenizer.wordChars(33, 255);
            streamTokenizer.whitespaceChars(0, 32);
            streamTokenizer.parseNumbers();
            streamTokenizer.eolIsSignificant(true);
            streamTokenizer.commentChar(35);
            this.openHeader(streamTokenizer);
            if (!this.isColor && this.sixteenBits) {
                if (this.rawBits) {
                    ImageProcessor imageProcessor = this.open16bitRawImage(bufferedInputStream, this.width, this.height);
                    ImageStack imageStack = new ImageStack(this.width, this.height);
                    imageStack.addSlice("", imageProcessor);
                    ImageStack imageStack2 = imageStack;
                    return imageStack2;
                }
                ImageProcessor imageProcessor = this.open16bitAsciiImage(streamTokenizer, this.width, this.height);
                ImageStack imageStack = new ImageStack(this.width, this.height);
                imageStack.addSlice("", imageProcessor);
                ImageStack imageStack3 = imageStack;
                return imageStack3;
            }
            if (!this.isColor) {
                byte[] byArray = new byte[this.width * this.height];
                ByteProcessor byteProcessor = new ByteProcessor(this.width, this.height, byArray, null);
                if (this.rawBits) {
                    this.openRawImage(bufferedInputStream, this.width * this.height, byArray);
                } else {
                    this.openAsciiImage(streamTokenizer, this.width * this.height, byArray);
                }
                for (int i = byArray.length - 1; i >= 0; --i) {
                    if (this.isBlackWhite) {
                        if (this.rawBits) {
                            if (i >= byArray.length / 8) continue;
                            for (int j = 7; j >= 0; --j) {
                                byArray[8 * i + 7 - j] = (byte)((byArray[i] & (int)Math.pow(2.0, j)) == 0 ? 255 : 0);
                            }
                            continue;
                        }
                        byArray[i] = (byte)(byArray[i] == 0 ? 255 : 0);
                        continue;
                    }
                    byArray[i] = (byte)(0xFF & 255 * (0xFF & byArray[i]) / this.maxValue);
                }
                ImageStack imageStack = new ImageStack(this.width, this.height);
                imageStack.addSlice("", byteProcessor);
                ImageStack imageStack4 = imageStack;
                return imageStack4;
            }
            if (!this.sixteenBits) {
                int[] nArray = new int[this.width * this.height];
                byte[] byArray = new byte[3 * this.width * this.height];
                ColorProcessor colorProcessor = new ColorProcessor(this.width, this.height, nArray);
                if (this.rawBits) {
                    this.openRawImage(bufferedInputStream, 3 * this.width * this.height, byArray);
                } else {
                    this.openAsciiImage(streamTokenizer, 3 * this.width * this.height, byArray);
                }
                for (int i = 0; i < this.width * this.height; ++i) {
                    int n = 0xFF & byArray[i * 3];
                    int n2 = 0xFF & byArray[i * 3 + 1];
                    int n3 = 0xFF & byArray[i * 3 + 2];
                    n = n * 255 / this.maxValue << 16;
                    n2 = n2 * 255 / this.maxValue << 8;
                    n3 = n3 * 255 / this.maxValue;
                    nArray[i] = 0xFF000000 | n | n2 | n3;
                }
                ImageStack imageStack = new ImageStack(this.width, this.height);
                imageStack.addSlice("", colorProcessor);
                ImageStack imageStack5 = imageStack;
                return imageStack5;
            }
            short[] sArray = new short[this.width * this.height];
            short[] sArray2 = new short[this.width * this.height];
            short[] sArray3 = new short[this.width * this.height];
            if (this.rawBits) {
                object = new byte[6 * this.width * this.height];
                this.openRawImage(bufferedInputStream, 6 * this.width * this.height, (byte[])object);
                for (int i = 0; i < this.width * this.height; ++i) {
                    int n = 0xFF & object[i * 6];
                    int n4 = 0xFF & object[i * 6 + 1];
                    int n5 = 0xFF & object[i * 6 + 2];
                    int n6 = 0xFF & object[i * 6 + 3];
                    int n7 = 0xFF & object[i * 6 + 4];
                    int n8 = 0xFF & object[i * 6 + 5];
                    sArray[i] = (short)(0xFFFF & n * 256 + n4);
                    sArray2[i] = (short)(0xFFFF & n5 * 256 + n6);
                    sArray3[i] = (short)(0xFFFF & n7 * 256 + n8);
                }
            } else {
                object = this.open16bitAsciiImage(streamTokenizer, 3 * this.width, this.height);
                short[] sArray4 = (short[])((ImageProcessor)object).getPixels();
                for (int i = 0; i < this.width * this.height; ++i) {
                    sArray[i] = (short)(sArray4[i * 3] & 0xFFFFFF);
                    sArray2[i] = (short)(sArray4[i * 3 + 1] & 0xFFFFFF);
                    sArray3[i] = (short)(sArray4[i * 3 + 2] & 0xFFFFFF);
                }
            }
            object = new ImageStack(this.width, this.height);
            ((ImageStack)object).addSlice("red", new ShortProcessor(this.width, this.height, sArray, null));
            ((ImageStack)object).addSlice("green", new ShortProcessor(this.width, this.height, sArray2, null));
            ((ImageStack)object).addSlice("blue", new ShortProcessor(this.width, this.height, sArray3, null));
            Object object2 = object;
            return object2;
        }
        finally {
            if (bufferedInputStream != null) {
                ((InputStream)bufferedInputStream).close();
            }
        }
    }

    public void openHeader(StreamTokenizer streamTokenizer) throws IOException {
        String string = this.getWord(streamTokenizer);
        if (string.equals("P1")) {
            this.rawBits = false;
            this.isColor = false;
            this.isBlackWhite = true;
        } else if (string.equals("P4")) {
            this.rawBits = true;
            this.isColor = false;
            this.isBlackWhite = true;
        } else if (string.equals("P2")) {
            this.rawBits = false;
            this.isColor = false;
            this.isBlackWhite = false;
        } else if (string.equals("P5")) {
            this.rawBits = true;
            this.isColor = false;
            this.isBlackWhite = false;
        } else if (string.equals("P3")) {
            this.rawBits = false;
            this.isColor = true;
            this.isBlackWhite = false;
        } else if (string.equals("P6")) {
            this.rawBits = true;
            this.isColor = true;
            this.isBlackWhite = false;
        } else {
            throw new IOException("PxM files must start with \"P1\" or \"P2\" or \"P3\" or \"P4\" or \"P5\" or \"P6\"");
        }
        this.width = this.getInt(streamTokenizer);
        this.height = this.getInt(streamTokenizer);
        if (this.width == -1 || this.height == -1) {
            throw new IOException("Error opening PxM header..");
        }
        if (!this.isBlackWhite) {
            this.maxValue = this.getInt(streamTokenizer);
            if (this.maxValue == -1) {
                throw new IOException("Error opening PxM header..");
            }
            this.sixteenBits = this.maxValue > 255;
        } else {
            this.maxValue = 255;
        }
        if (this.sixteenBits && this.maxValue > 65535) {
            throw new IOException("The maximum gray value is larger than 65535.");
        }
    }

    public void openAsciiImage(StreamTokenizer streamTokenizer, int n, byte[] byArray) throws IOException {
        int n2 = 0;
        int n3 = n / 20;
        if (n3 == 0) {
            n3 = 1;
        }
        while (true) {
            if (streamTokenizer.nextToken() == -1) break;
            if (streamTokenizer.ttype != -2) continue;
            byArray[n2++] = (byte)((int)streamTokenizer.nval & 0xFF);
            if (n2 % n3 != 0) continue;
            IJ.showProgress(0.5 + (double)n2 / (double)n / 2.0);
        }
        IJ.showProgress(1.0);
    }

    public void openRawImage(InputStream inputStream, int n, byte[] byArray) throws IOException {
        int n2 = 0;
        while (n2 < n && n2 >= 0) {
            n2 = inputStream.read(byArray, n2, n - n2);
        }
    }

    public ImageProcessor open16bitRawImage(InputStream inputStream, int n, int n2) throws IOException {
        int n3 = n * n2 * 2;
        byte[] byArray = new byte[n3];
        int n4 = 0;
        while (n4 < n3 && n4 >= 0) {
            n4 = inputStream.read(byArray, n4, n3 - n4);
        }
        short[] sArray = new short[n3 / 2];
        int n5 = 0;
        int n6 = 0;
        while (n5 < n3 / 2) {
            sArray[n5] = (short)((byArray[n6] & 0xFF) << 8 | byArray[n6 + 1] & 0xFF);
            ++n5;
            n6 += 2;
        }
        return new ShortProcessor(n, n2, sArray, null);
    }

    public ImageProcessor open16bitAsciiImage(StreamTokenizer streamTokenizer, int n, int n2) throws IOException {
        int n3 = 0;
        int n4 = n * n2;
        int n5 = n4 / 20;
        if (n5 == 0) {
            n5 = 1;
        }
        short[] sArray = new short[n4];
        while (true) {
            if (streamTokenizer.nextToken() == -1) break;
            if (streamTokenizer.ttype != -2) continue;
            sArray[n3++] = (short)((int)streamTokenizer.nval & 0xFFFF);
            if (n3 % n5 != 0) continue;
            IJ.showProgress(0.5 + (double)n3 / (double)n4 / 2.0);
        }
        IJ.showProgress(1.0);
        return new ShortProcessor(n, n2, sArray, null);
    }

    String getWord(StreamTokenizer streamTokenizer) throws IOException {
        block1: {
            do {
                if (streamTokenizer.nextToken() == -1) break block1;
            } while (streamTokenizer.ttype != -3);
            return streamTokenizer.sval;
        }
        return null;
    }

    int getInt(StreamTokenizer streamTokenizer) throws IOException {
        block1: {
            do {
                if (streamTokenizer.nextToken() == -1) break block1;
            } while (streamTokenizer.ttype != -2);
            return (int)streamTokenizer.nval;
        }
        return -1;
    }
}

