/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.gui.ImageWindow;
import ij.gui.Plot;
import ij.gui.ProfilePlot;
import ij.plugin.filter.Analyzer;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import ij.text.TextWindow;
import ij.util.Tools;
import java.awt.Button;
import java.awt.Color;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.CharArrayWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Properties;

public class PlotWindow
extends ImageWindow
implements ActionListener,
ClipboardOwner {
    public static final int CIRCLE = 0;
    public static final int X = 1;
    public static final int BOX = 3;
    public static final int TRIANGLE = 4;
    public static final int CROSS = 5;
    public static final int LINE = 2;
    private static final int WIDTH = 450;
    private static final int HEIGHT = 200;
    private static final String MIN = "pp.min";
    private static final String MAX = "pp.max";
    private static final String PLOT_WIDTH = "pp.width";
    private static final String PLOT_HEIGHT = "pp.height";
    private static final String OPTIONS = "pp.options";
    private static final int SAVE_X_VALUES = 1;
    private static final int AUTO_CLOSE = 2;
    private static final int LIST_VALUES = 4;
    private static final int INTERPOLATE = 8;
    private static final int NO_GRID_LINES = 16;
    private Button list;
    private Button save;
    private Button copy;
    private Label coordinates;
    private static String defaultDirectory = null;
    private Font font = new Font("Helvetica", 0, 12);
    private static int options;
    private int defaultDigits = -1;
    private boolean realXValues;
    private int xdigits;
    private int ydigits;
    private int markSize = 5;
    private static Plot staticPlot;
    private Plot plot;
    public static boolean saveXValues;
    public static boolean autoClose;
    public static int plotWidth;
    public static int plotHeight;
    public static boolean listValues;
    public static boolean interpolate;
    public static boolean noGridLines;

    public PlotWindow(String string, String string2, String string3, float[] fArray, float[] fArray2) {
        super(PlotWindow.createImage(string, string2, string3, fArray, fArray2));
        this.plot = staticPlot;
    }

    public PlotWindow(String string, String string2, String string3, double[] dArray, double[] dArray2) {
        this(string, string2, string3, Tools.toFloat(dArray), Tools.toFloat(dArray2));
    }

    PlotWindow(Plot plot) {
        super(plot.getImagePlus());
        this.plot = plot;
        this.draw();
    }

    static ImagePlus createImage(String string, String string2, String string3, float[] fArray, float[] fArray2) {
        staticPlot = new Plot(string, string2, string3, fArray, fArray2);
        return new ImagePlus(string, staticPlot.getBlankProcessor());
    }

    public void setLimits(double d, double d2, double d3, double d4) {
        this.plot.setLimits(d, d2, d3, d4);
    }

    public void addPoints(float[] fArray, float[] fArray2, int n) {
        this.plot.addPoints(fArray, fArray2, n);
    }

    public void addPoints(double[] dArray, double[] dArray2, int n) {
        this.addPoints(Tools.toFloat(dArray), Tools.toFloat(dArray2), n);
    }

    public void addErrorBars(float[] fArray) {
        this.plot.addErrorBars(fArray);
    }

    public void addLabel(double d, double d2, String string) {
        this.plot.addLabel(d, d2, string);
    }

    public void setColor(Color color) {
        this.plot.setColor(color);
    }

    public void setLineWidth(int n) {
        this.plot.setLineWidth(n);
    }

    public void changeFont(Font font) {
        this.plot.changeFont(font);
    }

    public void draw() {
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout(2));
        this.list = new Button(" List ");
        this.list.addActionListener(this);
        panel.add(this.list);
        this.save = new Button("Save...");
        this.save.addActionListener(this);
        panel.add(this.save);
        this.copy = new Button("Copy...");
        this.copy.addActionListener(this);
        panel.add(this.copy);
        this.coordinates = new Label("X=12345678, Y=12345678");
        this.coordinates.setFont(new Font("Monospaced", 0, 12));
        panel.add(this.coordinates);
        this.add(panel);
        this.plot.draw();
        this.pack();
        this.coordinates.setText("\t\t\t\t\t ");
        ImageProcessor imageProcessor = this.plot.getProcessor();
        if (imageProcessor instanceof ColorProcessor && this.imp.getProcessor() instanceof ByteProcessor) {
            this.imp.setProcessor(null, imageProcessor);
        } else {
            this.imp.updateAndDraw();
        }
        if (listValues) {
            this.showList();
        }
    }

    int getDigits(double d, double d2) {
        if ((double)Math.round(d) == d && (double)Math.round(d2) == d2) {
            return 0;
        }
        double d3 = (d = Math.abs(d)) < (d2 = Math.abs(d2)) && d > 0.0 ? d : d2;
        double d4 = Math.abs(d2 - d);
        if (d4 > 0.0 && d4 < d3) {
            d3 = d4;
        }
        int n = 1;
        if (d3 < 10.0) {
            n = 2;
        }
        if (d3 < 0.01) {
            n = 3;
        }
        if (d3 < 0.001) {
            n = 4;
        }
        if (d3 < 1.0E-4) {
            n = 5;
        }
        return n;
    }

    public void mouseMoved(int n, int n2) {
        super.mouseMoved(n, n2);
        if (this.plot != null && this.plot.frame != null && this.coordinates != null) {
            this.coordinates.setText(this.plot.getCoordinates(n, n2));
        }
    }

    void showListOLD() {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        this.initDigits();
        if (this.plot.errorBars != null) {
            string = saveXValues ? "X\tY\tErrorBar" : "Y\tErrorBar";
            for (int i = 0; i < this.plot.nPoints; ++i) {
                if (saveXValues) {
                    stringBuffer.append(IJ.d2s(this.plot.xValues[i], this.xdigits) + "\t" + IJ.d2s(this.plot.yValues[i], this.ydigits) + "\t" + IJ.d2s(this.plot.errorBars[i], this.ydigits) + "\n");
                    continue;
                }
                stringBuffer.append(IJ.d2s(this.plot.yValues[i], this.ydigits) + "\t" + IJ.d2s(this.plot.errorBars[i], this.ydigits) + "\n");
            }
        } else {
            string = saveXValues ? "X\tY" : "Y";
            for (int i = 0; i < this.plot.nPoints; ++i) {
                if (saveXValues) {
                    stringBuffer.append(IJ.d2s(this.plot.xValues[i], this.xdigits) + "\t" + IJ.d2s(this.plot.yValues[i], this.ydigits) + "\n");
                    continue;
                }
                stringBuffer.append(IJ.d2s(this.plot.yValues[i], this.ydigits) + "\n");
            }
        }
        TextWindow textWindow = new TextWindow("Plot Values", string, stringBuffer.toString(), 200, 400);
        if (autoClose) {
            this.imp.changes = false;
            this.close();
        }
    }

    void showList() {
        this.initDigits();
        String string = this.createHeading();
        String string2 = this.createData();
        TextWindow textWindow = new TextWindow("Plot Values", string, string2, 230, 400);
        if (autoClose) {
            this.imp.changes = false;
            this.close();
        }
    }

    private String createHeading() {
        String string = "";
        int n = this.plot.storedData.size() / 2;
        string = saveXValues ? string + (n == 1 ? "X\tY\t" : "X0\tY0\t") : string + (n == 1 ? "Y0\t" : "Y0\t");
        if (this.plot.errorBars != null) {
            string = string + "ERR\t";
        }
        for (int i = 1; i < n; ++i) {
            string = saveXValues ? string + "X" + i + "\tY" + i + "\t" : string + "Y" + i + "\t";
        }
        return string;
    }

    private String createData() {
        int n;
        float[] fArray;
        int n2 = 0;
        for (int i = 0; i < this.plot.storedData.size(); i += 2) {
            fArray = (float[])this.plot.storedData.get(i);
            n = fArray.length;
            n2 = n > n2 ? n : n2;
        }
        ArrayList<float[]> arrayList = new ArrayList<float[]>(this.plot.storedData);
        n = 0;
        if (this.plot.errorBars != null) {
            arrayList.add(2, this.plot.errorBars);
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n2; ++i) {
            n = this.plot.errorBars != null ? 1 : 0;
            int n3 = 0;
            while (n3 < arrayList.size()) {
                String string;
                if (saveXValues) {
                    fArray = (float[])arrayList.get(n3);
                    string = i < fArray.length ? IJ.d2s(fArray[i], this.xdigits) : "";
                    stringBuffer.append(string);
                    stringBuffer.append("\t");
                }
                string = i < (fArray = (float[])arrayList.get(++n3)).length ? IJ.d2s(fArray[i], this.ydigits) : "";
                stringBuffer.append(string);
                stringBuffer.append("\t");
                ++n3;
                if (n == 0) continue;
                fArray = (float[])arrayList.get(n3);
                string = i < fArray.length ? IJ.d2s(fArray[i], this.ydigits) : "";
                stringBuffer.append(string);
                stringBuffer.append("\t");
                ++n3;
                n = 0;
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    void saveAsText() {
        String string;
        FileDialog fileDialog = new FileDialog((Frame)this, "Save as Text...", 1);
        if (defaultDirectory != null) {
            fileDialog.setDirectory(defaultDirectory);
        }
        fileDialog.setVisible(true);
        String string2 = fileDialog.getFile();
        if (string2 == null) {
            return;
        }
        defaultDirectory = string = fileDialog.getDirectory();
        fileDialog.dispose();
        PrintWriter printWriter = null;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string + string2);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            printWriter = new PrintWriter(bufferedOutputStream);
        }
        catch (IOException iOException) {
            IJ.error("" + iOException);
            return;
        }
        IJ.wait(250);
        IJ.showStatus("Saving plot values...");
        this.initDigits();
        printWriter.print(this.createData());
        printWriter.close();
        if (autoClose) {
            this.imp.changes = false;
            this.close();
        }
    }

    void copyToClipboard() {
        Clipboard clipboard = null;
        try {
            clipboard = this.getToolkit().getSystemClipboard();
        }
        catch (Exception exception) {
            clipboard = null;
        }
        if (clipboard == null) {
            IJ.error("Unable to copy to Clipboard.");
            return;
        }
        IJ.showStatus("Copying plot values...");
        this.initDigits();
        CharArrayWriter charArrayWriter = new CharArrayWriter(this.plot.nPoints * 4);
        PrintWriter printWriter = new PrintWriter(charArrayWriter);
        for (int i = 0; i < this.plot.nPoints; ++i) {
            if (saveXValues) {
                printWriter.print(IJ.d2s(this.plot.xValues[i], this.xdigits) + "\t" + IJ.d2s(this.plot.yValues[i], this.ydigits) + "\n");
                continue;
            }
            printWriter.print(IJ.d2s(this.plot.yValues[i], this.ydigits) + "\n");
        }
        String string = charArrayWriter.toString();
        printWriter.close();
        StringSelection stringSelection = new StringSelection(string);
        clipboard.setContents(stringSelection, this);
        IJ.showStatus(string.length() + " characters copied to Clipboard");
        if (autoClose) {
            this.imp.changes = false;
            this.close();
        }
    }

    void initDigits() {
        boolean bl;
        int n = 2;
        int n2 = Analyzer.getPrecision();
        int n3 = Analyzer.getMeasurements();
        boolean bl2 = bl = (n3 & 0x200000) != 0;
        if (bl) {
            if (n2 < 2) {
                n2 = 2;
            }
            this.xdigits = this.ydigits = -n2;
            return;
        }
        if (this.ydigits != 9 || n2 >= 6) {
            this.ydigits = n2;
            if (this.ydigits == 0) {
                this.ydigits = 2;
            }
            n = this.ydigits;
        }
        if (this.ydigits != this.defaultDigits) {
            int n4;
            this.realXValues = false;
            for (n4 = 0; n4 < this.plot.xValues.length; ++n4) {
                if ((float)((int)this.plot.xValues[n4]) == this.plot.xValues[n4]) continue;
                this.realXValues = true;
                break;
            }
            n4 = 0;
            for (int i = 0; i < this.plot.yValues.length; ++i) {
                if ((float)((int)this.plot.yValues[i]) == this.plot.yValues[i]) continue;
                n4 = 1;
                break;
            }
            if (n2 < 6 && n4 != 0) {
                this.ydigits = 9;
            }
            if (n4 == 0) {
                this.ydigits = 0;
            }
            this.defaultDigits = this.ydigits;
        }
        int n5 = this.xdigits = this.realXValues ? this.ydigits : 0;
        if (this.xdigits == 0 && this.plot.xValues.length >= 2 && (double)(this.plot.xValues[1] - this.plot.xValues[0]) < 1.0) {
            this.xdigits = n;
        }
    }

    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.list) {
            this.showList();
        } else if (object == this.save) {
            this.saveAsText();
        } else {
            this.copyToClipboard();
        }
    }

    public float[] getXValues() {
        return this.plot.xValues;
    }

    public float[] getYValues() {
        return this.plot.yValues;
    }

    public void drawPlot(Plot plot) {
        this.plot = plot;
        this.imp.setProcessor(null, plot.getProcessor());
    }

    public static void savePreferences(Properties properties) {
        double d = ProfilePlot.getFixedMin();
        double d2 = ProfilePlot.getFixedMax();
        if ((d != 0.0 || d2 != 0.0) && d < d2) {
            properties.put(MIN, Double.toString(d));
            properties.put(MAX, Double.toString(d2));
        }
        if (plotWidth != 450 || plotHeight != 200) {
            properties.put(PLOT_WIDTH, Integer.toString(plotWidth));
            properties.put(PLOT_HEIGHT, Integer.toString(plotHeight));
        }
        int n = 0;
        if (saveXValues) {
            n |= 1;
        }
        if (autoClose && !listValues) {
            n |= 2;
        }
        if (listValues) {
            n |= 4;
        }
        if (!interpolate) {
            n |= 8;
        }
        if (noGridLines) {
            n |= 0x10;
        }
        properties.put(OPTIONS, Integer.toString(n));
    }

    static {
        plotWidth = 450;
        plotHeight = 200;
        IJ.register(PlotWindow.class);
        options = Prefs.getInt(OPTIONS, 1);
        saveXValues = (options & 1) != 0;
        autoClose = (options & 2) != 0;
        listValues = (options & 4) != 0;
        plotWidth = Prefs.getInt(PLOT_WIDTH, 450);
        plotHeight = Prefs.getInt(PLOT_HEIGHT, 200);
        interpolate = (options & 8) == 0;
        noGridLines = (options & 0x10) != 0;
    }
}

