% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluateResults.R
\name{mergeAnalytes}
\alias{mergeAnalytes}
\title{Function to combine analytes for defined categories}
\usage{
mergeAnalytes(
  tableTCs,
  errorList,
  catList = NULL,
  catLabels = NULL,
  distTypes = TRUE
)
}
\arguments{
\item{tableTCs}{(data.frame) containing all information about the simulated test sets}

\item{errorList}{(list) containing for each method the table with the computed error measurements}

\item{catList}{(list) containing the categories to split the dataset}

\item{catLabels}{(list) containing the labels that will be used for the categories}

\item{distTypes}{(logical) indicating if 'catList' refers to analytes (FALSE, default) or distribution types (TRUE)}
}
\value{
(list) containing the merged performance measurements grouped according to specified category
}
\description{
The feature can either be the pathological fraction, the sample size or the overlap (category) individually or cumulative (_cum). 
For a individualized categorisation see \code{getSubsetForDefinedCats}.
}
\author{
Tatjana Ammer \email{tatjana.ammer@roche.com}
}
