/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import java.sql.SQLException;
import org.h2.command.Prepared;
import org.h2.command.ddl.DefineCommand;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.result.ResultInterface;
import org.h2.table.Column;
import org.h2.table.Table;
import org.h2.table.TableData;
import org.h2.util.StatementBuilder;

public class Analyze
extends DefineCommand {
    private int sampleRows = 10000;

    public Analyze(Session session) {
        super(session);
    }

    public int update() throws SQLException {
        this.session.commit(true);
        Database database = this.session.getDatabase();
        this.session.getUser().checkAdmin();
        for (Table table : database.getAllTablesAndViews(false)) {
            Column[] columnArray;
            if (!(table instanceof TableData)) continue;
            StatementBuilder statementBuilder = new StatementBuilder("SELECT ");
            for (Column column : columnArray = table.getColumns()) {
                statementBuilder.appendExceptFirst(", ");
                statementBuilder.append("SELECTIVITY(").append(column.getSQL()).append(')');
            }
            statementBuilder.append(" FROM ").append(table.getSQL());
            if (this.sampleRows > 0) {
                statementBuilder.append(" LIMIT 1 SAMPLE_SIZE ").append(this.sampleRows);
            }
            String object = statementBuilder.toString();
            Prepared prepared = this.session.prepare(object);
            ResultInterface resultInterface = prepared.query(0);
            resultInterface.next();
            for (int column = 0; column < columnArray.length; ++column) {
                int n = resultInterface.currentRow()[column].getInt();
                columnArray[column].setSelectivity(n);
            }
            database.update(this.session, table);
        }
        return 0;
    }

    public void setTop(int n) {
        this.sampleRows = n;
    }
}

