% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genMissionGetDates.R
\name{senGetDates}
\alias{senGetDates}
\title{Return the capturing dates of Sentinel-2 images}
\usage{
senGetDates(str, ...)
}
\arguments{
\item{str}{the full path(s) or official name(s) of the Sentinel
images from which the capturing date is retrieved.}

\item{...}{arguments for nested functions:
\itemize{
  \item \code{format} the format of the date being returned.
}}
}
\description{
\code{senGetDates} reads the official name of a Sentinel-2 image and returns
the capturing date, as a \code{Date} class object.
}
\details{
The function works with file names (or their paths) regardless of their
extension. The function accepts more than on file path, which can be passed
as a \code{characters} vector. Dates are returned as `\code{YYYY-mm-dd}' by
default. If another format is required, it can be modified through the
argument \code{format}.
}
\examples{
# getting the capturing date from the name of Sentinel-2 images
str <- c("S2A_MSIL1C_20170102T111442_N0204_R137_T30TWN_20170102T111441.SAFE",
       "S2A_OPER_PRD_MSIL1C_PDMC_20160308T090616_R094_V20160305T110109_20160305T110109")
dt <- senGetDates(str)
print(dt)
print(format(dt,"\%Y\%j"))
senGetDates(str, format = "\%Y\%j")

}
