% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_chrom.R
\name{read_chrom}
\alias{read_chrom}
\title{Read bidimensional total ion current chromatogram.}
\usage{
read_chrom(name, mod_time, sam_rate, per_eval = 0.1)
}
\arguments{
\item{name}{A name of the netCDF file to which the data will be retrieved.}

\item{mod_time}{The modulation time of the chromatographic run.}

\item{sam_rate}{the sampling rate of the equipment. If sam_rate is missing,
the sampling rate is calculated by the dividing one by the
diference of two adjacent scan time.}

\item{per_eval}{An integer with the percentage of the run time to be
evaluate, if the sampling rate is homogeneous.}
}
\description{
`read_GCxGC` returns a \emph{raw_GCxGC} with the sample name, the modulation
time and the bidimensional chromatogram.
}
\details{
This function reads the netCDF file and retrieve the values in the
\emph{total_intensity} variable. Then, with the provided sampling rate and
modulation time, it is folded into a numerical matrix (bidimensional
chromatogram). This function is an adaptation of the presented routine
from \insertCite{Skov2008;textual}{RGCxGC}.

For unusual retention times, more than 60 seconds, the chemical equipment
converts the measured points per minute in function of sampling rate.
}
\examples{
 
GB08_fl <- system.file("extdata", "08GB.cdf", package = "RGCxGC")
GB08 <- read_chrom(GB08_fl, 5L)

}
\references{
\insertAllCited{}
}
