% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kuttner.R
\name{plot.KuttnerFit}
\alias{plot.KuttnerFit}
\title{Plots for a \code{KuttnerFit} object}
\usage{
\method{plot}{KuttnerFit}(
  x,
  alpha = 0.05,
  bounds = TRUE,
  path = NULL,
  combine = TRUE,
  prefix = NULL,
  device = "png",
  width = 10,
  height = 3,
  ...
)
}
\arguments{
\item{x}{An object of class \code{KuttnerFit}.}

\item{alpha}{The significance level for the trend (\code{alpha in [0,1]}). Only used if
\code{bounds = TRUE}.}

\item{bounds}{A logical indicating whether significance intervals should be plotted around
gdp. The default is \code{bounds = TRUE}.}

\item{path}{An optional file path. If specified, the plots will be saved using the format
in \code{device} under the given path.}

\item{combine}{A logical indicating whether the diagnostic plots should be combined or not,
the default is \code{TRUE}.}

\item{prefix}{An optional character string to be added to the names of the plots in case
\code{path} is specified.}

\item{device}{Device passed on to \code{ggplot} for plot saving. Options are 
\code{"eps", "ps", "tex"} (pictex), \code{"pdf", "jpeg", "tiff", "png", "bmp", "svg"} 
or \code{"wmf"}.}

\item{width}{The plot width in case of printing.}

\item{height}{The plot height in case of printing.}

\item{...}{Ignored.}
}
\value{
No return value, plots are printed.
}
\description{
Plots potential growth and the output gap and gives diagnostic plots based on
standardized residuals for objects of class \code{KuttnerFit}.
}
