% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gibbs_steps.R
\name{.gibbsStepAR}
\alias{.gibbsStepAR}
\title{Draws from the posterior of the parameters of the AR(p), \code{p = 1,2} cycle equation,
conditional on the states.}
\usage{
.gibbsStepAR(Y, parLast, parDistr, varNames)
}
\arguments{
\item{Y}{a \code{Tn x 1} vector.}

\item{parLast}{A \code{(p + 1) x 1} vector containing the last draw for the
autoregressive coefficients and the innovation variance (in that order).}

\item{parDistr}{A \code{4 x (p + 1)} matrix with prior distribution and box constraints for
the parameters of each variable (the order of the columns is as for parLast). In each
column, the first two entries contain the prior hyperparameters and the last two entries
the upper and lower bound.}

\item{varNames}{A vector with parameter names in the correct order, i.e., autoregressive
coefficients, variance.}
}
\description{
Draws from the posterior of the parameters of the AR(p), \code{p = 1,2} cycle equation,
conditional on the states.
}
\details{
The autoregressive parameter and the innovation variance are drawn sequentially.

If the cycle is AR(1) process, the posterior is obtained by conjugacy. If it is
  an AR(2) process, a Metropolis-Hastings step is implemented.

Conditional on the autoregressive parameters, the innovation variance is drawn
  from the Inverse Gamma posterior which is obtained by conjugacy.
}
\keyword{internal}
