% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/segments.R
\name{list_segments}
\alias{list_segments}
\title{Lists segments which the user has access to}
\usage{
list_segments(start.index = NULL, max.results = NULL, token)
}
\arguments{
\item{start.index}{integer. An index of the first segment to retrieve. Use this parameter as a pagi- nation mechanism along with the max-results parameter.}

\item{max.results}{integer. The maximum number of segments to include in this response.}

\item{token}{\code{\link[httr]{Token2.0}} class object with a valid authorization data.}
}
\value{
An segment collection lists Analytics segments that the user has access to. Each resource in the collection corresponds to a single Analytics segment.
\item{id}{Segment ID.}
\item{segment.id}{Segment ID. Can be used with the segment parameter in Data Feed.}
\item{name}{Segment name.}
\item{definition}{Segment definition.}
\item{type}{Type for a segment. Possible values are "BUILT_IN" or "CUSTOM".}
\item{created}{time the segment was created.}
\item{updated}{time the segment was last modified.}
}
\description{
Lists segments which the user has access to
}
\references{
\href{https://developers.google.com/analytics/devguides/config/mgmt/v3/mgmtReference/management/segments}{Google Management API - Segments}

\href{https://developers.google.com/analytics/devguides/reporting/core/v3/segments}{Core Reporting API - Segments}
}
\seealso{
\code{\link{authorize}}

Other Management API: \code{\link{get_custom_dimension}};
  \code{\link{get_custom_metric}};
  \code{\link{get_experiment}}; \code{\link{get_filter}};
  \code{\link{get_goal}}; \code{\link{get_profile}};
  \code{\link{get_unsampled_report}};
  \code{\link{get_webproperty}};
  \code{\link{list_accounts}};
  \code{\link{list_custom_dimensions}};
  \code{\link{list_custom_metrics}};
  \code{\link{list_custom_sources}};
  \code{\link{list_experiments}};
  \code{\link{list_filters}}; \code{\link{list_goals}};
  \code{\link{list_profiles}};
  \code{\link{list_unsampled_reports}};
  \code{\link{list_webproperties}}
}

