% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/list-mgmt.R
\name{list_webproperties}
\alias{get_webproperties}
\alias{list_webproperties}
\title{Lists web properties which the user has access to}
\usage{
list_webproperties(account.id = "~all", start.index = NULL,
  max.results = NULL, token, verbose = getOption("rga.verbose"))

get_webproperties(account.id = "~all", start.index = NULL,
  max.results = NULL, token, verbose = getOption("rga.verbose"))
}
\arguments{
\item{account.id}{integer or character. Account ID to retrieve web properties for. Can either be a specific account ID or "~all", which refers to all the accounts that user has access to.}

\item{start.index}{integer. An index of the first entity to retrieve. Use this parameter as a pagination mechanism along with the max-results parameter.}

\item{max.results}{integer. The maximum number of web properties to include in this response.}

\item{token}{\code{\link[httr]{Token2.0}} class object with a valid authorization data.}

\item{verbose}{logical. Should print information verbose?}
}
\value{
A web property collection lists Analytics web properties to which the user has access. Each resource in the collection corresponds to a single Analytics web property.
\item{id}{Web property ID of the form UA-XXXXX-YY.}
\item{accountId}{Account ID to which this web property belongs.}
\item{internalWebPropertyId}{Internal ID for this web property.}
\item{name}{Name of this web property.}
\item{websiteUrl}{Website url for this web property.}
\item{level}{Level for this web property. Possible values are STANDARD or PREMIUM.}
\item{profileCount}{View (Profile) count for this web property.}
\item{industryVertical}{The industry vertical/category selected for this web property.}
\item{defaultProfileId}{Default view (profile) ID.}
\item{permissions}{Permissions the user has for this web property.}
\item{created}{Time this web property was created.}
\item{updated}{Time this web property was last modified.}
}
\description{
Lists web properties which the user has access to
}
\references{
\href{https://developers.google.com/analytics/devguides/config/mgmt/v3/mgmtReference/management/webproperties}{Google Management API - Web Properties}

\href{https://ga-dev-tools.appspot.com/account-explorer/}{Google Analytics Demos & Tools - Account Explorer}
}
\seealso{
\code{\link{authorize}}

Other The Google Analytics Management API: \code{\link{get_accounts}},
  \code{\link{list_accounts}}; \code{\link{get_goals}},
  \code{\link{list_goals}}; \code{\link{get_goal}};
  \code{\link{get_profiles}}, \code{\link{list_profiles}};
  \code{\link{get_profile}}; \code{\link{get_segments}},
  \code{\link{list_segments}};
  \code{\link{get_webproperty}}
}

