/*
 * Decompiled with CFR 0.152.
 */
package freak.module.searchspace.logictree;

import freak.module.searchspace.logictree.Data;
import freak.module.searchspace.logictree.OperatorNode;
import freak.module.searchspace.logictree.StaticConstantNode;
import freak.module.searchspace.logictree.StaticInputNode;
import java.io.Serializable;
import java.util.BitSet;

public class VariableCompareNode
implements OperatorNode,
Serializable {
    private StaticConstantNode constant;
    private StaticInputNode input;
    private boolean less;
    private boolean equal;
    private boolean greater;
    private boolean[] allowedOp;
    private byte[] allowedOpList;

    public VariableCompareNode(StaticConstantNode cn, StaticInputNode in, boolean less, boolean equal, boolean greater) {
        boolean[] blArray = new boolean[8];
        blArray[2] = true;
        blArray[3] = true;
        blArray[5] = true;
        blArray[6] = true;
        this.allowedOp = blArray;
        this.allowedOpList = new byte[]{2, 3, 5, 6};
        this.constant = cn;
        this.input = in;
        if (this.allowedOp[this.internOpID(less, equal, greater)]) {
            this.less = less;
            this.equal = equal;
            this.greater = greater;
        } else {
            this.setRandomState();
        }
    }

    public VariableCompareNode(int maxConstant, int numVariables) {
        this(new StaticConstantNode(maxConstant), new StaticInputNode(numVariables), Data.nextRandBoolean(), Data.nextRandBoolean(), Data.nextRandBoolean());
    }

    private byte internOpID(boolean less, boolean equal, boolean greater) {
        byte rueckgabe = 0;
        if (less) {
            rueckgabe = (byte)(rueckgabe + 4);
        }
        if (equal) {
            rueckgabe = (byte)(rueckgabe + 2);
        }
        if (greater) {
            rueckgabe = (byte)(rueckgabe + 1);
        }
        return rueckgabe;
    }

    private boolean getLFromInternOpID(byte id) {
        return id >= 4;
    }

    private boolean getEFromInternOpID(byte id) {
        return id == 2 || id == 3 || id == 6 || id == 7;
    }

    private boolean getGFromInternOpID(byte id) {
        return id == 1 || id == 3 || id == 5 || id == 7;
    }

    private void buildAllowedOpList() {
        int anzahl = 0;
        int i = 0;
        while (i < 8) {
            if (this.allowedOp[i]) {
                anzahl = (byte)(anzahl + 1);
            }
            i = (byte)(i + 1);
        }
        this.allowedOpList = new byte[anzahl];
        anzahl = 0;
        i = 0;
        while (i < 8) {
            if (this.allowedOp[i]) {
                this.allowedOpList[anzahl] = i;
                anzahl = (byte)(anzahl + 1);
            }
            i = (byte)(i + 1);
        }
    }

    private byte getRandomAllowedOp() {
        byte zz = (byte)Data.nextRandInt(this.allowedOpList.length);
        return this.allowedOpList[zz];
    }

    private void setRandomState() {
        byte op = this.getRandomAllowedOp();
        this.less = this.getLFromInternOpID(op);
        this.equal = this.getEFromInternOpID(op);
        this.greater = this.getGFromInternOpID(op);
    }

    public void allowOperator(boolean less, boolean equal, boolean greater) {
        this.allowedOp[this.internOpID((boolean)less, (boolean)equal, (boolean)greater)] = true;
        this.buildAllowedOpList();
    }

    public void forbidOperator(boolean less, boolean equal, boolean greater) {
        this.allowedOp[this.internOpID((boolean)less, (boolean)equal, (boolean)greater)] = false;
        this.buildAllowedOpList();
    }

    public boolean getValue(byte[] row) {
        boolean c;
        int i = this.input.getValue(row);
        int j = this.constant.getValue(row);
        boolean a = this.equal && i == j;
        boolean b = this.less && i < j;
        boolean bl = c = this.greater && i > j;
        return a || b || c;
    }

    public BitSet getValueBitset() {
        throw new RuntimeException("Unsupported method.");
    }

    public void updateBitset() {
        throw new RuntimeException("Unsupported method.");
    }

    public BitSet getLiteralBitSet() {
        throw new RuntimeException("Unsupported method.");
    }

    public int getSubtreeSize() {
        return 1;
    }

    StaticConstantNode getConstantChild() {
        return this.constant;
    }

    StaticInputNode getInputChild() {
        return this.input;
    }

    void randomState() {
        this.setRandomState();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof VariableCompareNode)) {
            return false;
        }
        VariableCompareNode cn = (VariableCompareNode)o;
        return this.getConstantChild().equals(cn.getConstantChild()) && this.getInputChild().equals(cn.getInputChild());
    }

    public String toString() {
        String rueckgabe = "(" + this.input.toString();
        if (this.less) {
            rueckgabe = String.valueOf(rueckgabe) + "<";
        }
        if (this.equal) {
            rueckgabe = String.valueOf(rueckgabe) + "=";
        }
        if (this.greater) {
            rueckgabe = String.valueOf(rueckgabe) + ">";
        }
        rueckgabe = String.valueOf(rueckgabe) + this.constant.toString() + ")";
        return rueckgabe;
    }

    public Object clone() {
        StaticConstantNode cn = (StaticConstantNode)this.constant.clone();
        StaticInputNode in = (StaticInputNode)this.input.clone();
        VariableCompareNode com = new VariableCompareNode(cn, in, this.less, this.equal, this.greater);
        return com;
    }
}

