/*
 * Decompiled with CFR 0.152.
 */
package freak.module.operator.mutation.bitstring;

import freak.core.graph.Mutation;
import freak.core.graph.OperatorGraph;
import freak.core.modulesupport.Configurable;
import freak.core.population.Individual;
import freak.core.searchspace.HasDimension;
import freak.core.util.FreakMath;
import freak.module.searchspace.BitString;
import freak.module.searchspace.BitStringGenotype;

public class KBitMover
extends Mutation
implements Configurable {
    protected int k = 1;

    public KBitMover(OperatorGraph graph) {
        super(graph);
    }

    public void initialize() {
        super.initialize();
        int dim = ((HasDimension)((Object)this.getGenotypeSearchSpace())).getDimension();
        if (this.k > dim) {
            this.k = dim;
        }
    }

    public void setPropertyK(Integer num) {
        if (num >= 0 && num <= ((BitString)this.getGenotypeSearchSpace()).getDimension() / 2) {
            this.k = num;
        }
    }

    public Integer getPropertyK() {
        return new Integer(this.k);
    }

    public String getLongDescriptionForkK() {
        return "Number of positions of one-bits to move.";
    }

    public String getShortDescriptionForK() {
        return "k";
    }

    protected Individual doMutation(Individual ind) {
        int dimension = ((BitString)this.graph.getSchedule().getGenotypeSearchSpace()).getDimension();
        BitStringGenotype bs = (BitStringGenotype)((BitStringGenotype)ind.getGenotype()).clone();
        int kLocal = this.k;
        int numberOfOnes = bs.getBitSet().cardinality();
        if (numberOfOnes < kLocal) {
            kLocal = numberOfOnes;
        }
        if (dimension - numberOfOnes < kLocal) {
            kLocal = dimension - numberOfOnes;
        }
        int onesCount = 0;
        int zeroesCount = 0;
        int[] ones = new int[numberOfOnes];
        int[] zeroes = new int[dimension - numberOfOnes];
        int i = 0;
        while (i < dimension) {
            if (bs.get(i)) {
                ones[onesCount++] = i;
            } else {
                zeroes[zeroesCount++] = i;
            }
            ++i;
        }
        int[] flipOnes = FreakMath.getKofN(this.graph.getSchedule(), kLocal, numberOfOnes);
        int[] flipzeroes = FreakMath.getKofN(this.graph.getSchedule(), kLocal, dimension - numberOfOnes);
        int i2 = 0;
        while (i2 < kLocal) {
            bs.flip(ones[flipOnes[i2]]);
            bs.flip(zeroes[flipzeroes[i2]]);
            ++i2;
        }
        return new Individual(this.graph.getSchedule(), bs, new Individual[]{ind});
    }

    public String getDescription() {
        return "Exactly k randomly chosen one-bits and k randomly chosen zero-bits are flipped.";
    }

    public String getName() {
        return "k-Bit Mover";
    }
}

