/*
 * Decompiled with CFR 0.152.
 */
package freak.module.operator.crossover.cycle;

import edu.cornell.lassp.houle.RngPack.RandomElement;
import freak.core.graph.OperatorGraph;
import freak.core.population.Individual;
import freak.module.operator.crossover.MultiPairwiseCrossover;
import freak.module.searchspace.PermutationGenotype;

public class MaximalPreservativeCrossover
extends MultiPairwiseCrossover {
    public MaximalPreservativeCrossover(OperatorGraph graph) {
        super(graph);
    }

    private int[] transformToFunctionTable(int[] cycle) {
        int[] ft = new int[cycle.length];
        int i = 0;
        while (i < cycle.length - 1) {
            ft[cycle[i] - 1] = cycle[i + 1];
            ++i;
        }
        ft[cycle[cycle.length - 1] - 1] = cycle[0];
        return ft;
    }

    private int[] calculateInverse(int[] perm) {
        int[] inv = new int[perm.length];
        int i = 0;
        while (i < perm.length) {
            inv[perm[i] - 1] = i;
            ++i;
        }
        return inv;
    }

    protected Individual doCrossover(Individual ind1, Individual ind2) {
        RandomElement re = this.graph.getSchedule().getRandomElement();
        int[] gt1 = ((PermutationGenotype)ind1.getGenotype()).getIntArray();
        int[] gt2 = ((PermutationGenotype)ind2.getGenotype()).getIntArray();
        int[] newGt = new int[gt1.length];
        boolean[] visited = new boolean[gt1.length];
        int numVis = 0;
        int i = 0;
        while (i < gt1.length) {
            visited[i] = false;
            ++i;
        }
        int xover1 = re.choose(0, gt1.length - 2);
        int xover2 = re.choose(xover1 + 1, gt1.length - 1);
        int i2 = 0;
        while (i2 < xover2 - xover1) {
            newGt[i2] = gt2[xover1 + i2 + 1];
            visited[gt2[xover1 + i2 + 1] - 1] = true;
            ++i2;
        }
        numVis = xover2 - xover1;
        int[] ft1 = this.transformToFunctionTable(gt1);
        int[] ft2 = this.transformToFunctionTable(gt2);
        int[] inv1 = this.calculateInverse(gt1);
        while (numVis < gt1.length) {
            int nextCityOnTour1 = ft1[newGt[numVis - 1] - 1];
            if (!visited[nextCityOnTour1 - 1]) {
                visited[nextCityOnTour1 - 1] = true;
                newGt[numVis] = nextCityOnTour1;
                ++numVis;
                continue;
            }
            int nextCityOnTour2 = ft2[newGt[numVis - 1] - 1];
            if (!visited[nextCityOnTour2 - 1]) {
                visited[nextCityOnTour2 - 1] = true;
                newGt[numVis] = nextCityOnTour2;
                ++numVis;
                continue;
            }
            int i3 = inv1[newGt[numVis - 1] - 1];
            while (visited[gt1[i3] - 1]) {
                if (i3 < gt1.length - 1) {
                    ++i3;
                    continue;
                }
                i3 = 0;
            }
            visited[gt1[i3] - 1] = true;
            newGt[numVis] = gt1[i3];
            ++numVis;
        }
        return new Individual(this.graph.getSchedule(), new PermutationGenotype(newGt), new Individual[]{ind1, ind2});
    }

    public String getDescription() {
        return "Two crossing points are chosen at random. The subtour in the middle part of the second individual is taken over. Now we try to use edges in the parents to complete the tour. Edges in the first individual have a greater priority than those in the second individual. If both parent don't have permitted edges starting at the last city visited, then the first following city in the first individual which hasn't been visited becomes the next city on the tour.\nExample: ind1 = 12|3456|789, ind2 = 84|1593|627\nThe subtour 1593 is taken from ind2. 3->4 is taken from ind1, so we have the subtour 15934. Both 4->5 from ind1 and 4->1 are not allowed, so we continue with 6. Now we have the subtour: 159346. We can add 6->7->8 from ind1. Now just city number 2 isn't visited yet. We get: 159346782.";
    }

    public String getName() {
        return "Maximal Preservative Crossover";
    }
}

