/*
 * Decompiled with CFR 0.152.
 */
package freak.module.mapper.generalstring;

import edu.cornell.lassp.houle.RngPack.RandomElement;
import freak.core.control.Schedule;
import freak.core.event.BatchEvent;
import freak.core.event.BatchEventListener;
import freak.core.event.EventListener;
import freak.core.mapper.AbstractMapper;
import freak.core.population.Genotype;
import freak.core.searchspace.SearchSpace;
import freak.module.searchspace.GeneralString;
import freak.module.searchspace.GeneralStringGenotype;

public class Permuter_Mapper
extends AbstractMapper
implements BatchEventListener {
    private int[] forwards;
    private int[] backwards;

    public Permuter_Mapper(Schedule schedule) {
        super(schedule);
        if (schedule.getPhenotypeSearchSpace() instanceof GeneralString) {
            this.createPermutation();
        }
    }

    public void initialize() {
        super.initialize();
        int dimension = ((GeneralString)this.schedule.getPhenotypeSearchSpace()).getDimension();
        if (this.forwards != null && this.forwards.length != dimension) {
            this.createPermutation();
        }
    }

    public void createPermutation() {
        int dimension = ((GeneralString)this.getSchedule().getGenotypeSearchSpace()).getDimension();
        this.forwards = new int[dimension];
        this.backwards = new int[dimension];
        RandomElement re = this.schedule.getRandomElement();
        int i = 0;
        while (i < dimension) {
            this.forwards[i] = i;
            ++i;
        }
        i = 0;
        while (i < dimension) {
            int j = re.choose(i, dimension - 1);
            int tmp = this.forwards[j];
            this.forwards[j] = this.forwards[i];
            this.forwards[i] = tmp;
            this.backwards[tmp] = i++;
        }
    }

    public Genotype genotypeToPhenotype(Genotype genotype) {
        GeneralString searchspace = (GeneralString)this.schedule.getPhenotypeSearchSpace();
        int dimension = searchspace.getDimension();
        int numChars = searchspace.getNumChars();
        int[] pheno = new int[dimension];
        int[] geno = ((GeneralStringGenotype)genotype).getIntArray();
        int i = 0;
        while (i < dimension) {
            pheno[i] = geno[this.forwards[i]];
            ++i;
        }
        return new GeneralStringGenotype(pheno, numChars);
    }

    public Genotype phenotypeToGenotype(Genotype genotype) {
        if (this.backwards == null) {
            return genotype;
        }
        GeneralString searchspace = (GeneralString)this.schedule.getPhenotypeSearchSpace();
        int dimension = searchspace.getDimension();
        int numChars = searchspace.getNumChars();
        int[] geno = new int[dimension];
        int[] pheno = ((GeneralStringGenotype)genotype).getIntArray();
        int i = 0;
        while (i < dimension) {
            geno[i] = pheno[this.backwards[i]];
            ++i;
        }
        return new GeneralStringGenotype(geno, numChars);
    }

    public SearchSpace getGenotypeSearchSpace() {
        return this.schedule.getPhenotypeSearchSpace();
    }

    public String getName() {
        return "General String Permuter";
    }

    public String getDescription() {
        return "Permutes the chars in a randomly created order.";
    }

    public void createEvents() {
        this.schedule.getEventController().addEvent((EventListener)this, BatchEvent.class, this.schedule);
    }

    public void batchStarted(BatchEvent evt) {
        this.createPermutation();
    }
}

