/*
 * Decompiled with CFR 0.152.
 */
package freak.module.view;

import freak.core.control.Schedule;
import freak.core.modulesupport.Configurable;
import freak.core.modulesupport.UnsupportedEnvironmentException;
import freak.core.population.Genotype;
import freak.core.population.Individual;
import freak.core.population.IndividualList;
import freak.core.view.SingleIndividualView;
import freak.core.view.swingsupport.FreakSwingModel;
import freak.core.view.swingsupport.UpdateManager;
import freak.module.fitness.cycle.tsp.TSP;
import freak.module.searchspace.PermutationGenotype;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public class EuclideanView
extends SingleIndividualView
implements Configurable,
FreakSwingModel {
    private boolean displayNumbers = true;
    private Color numberColor = Color.blue;
    private Color pointColor = Color.red;
    private Color lineColor = Color.darkGray;

    public EuclideanView(Schedule schedule) {
        super(schedule);
        this.setDisplayStrategy(1);
    }

    public void testSchedule(Schedule schedule) throws UnsupportedEnvironmentException {
        super.testSchedule(schedule);
        if (!(schedule.getRealFitnessFunction() instanceof TSP)) {
            throw new UnsupportedEnvironmentException("Unsupported fitness function.");
        }
    }

    public JPanel createIndividualPanel() {
        return new E2DPanel(this);
    }

    public String getName() {
        return "Euclidean TSP View";
    }

    public String getDescription() {
        return "Graphical view of an euclidean TSP.";
    }

    public Class[] getInputDataTypes() {
        return new Class[]{IndividualList.class};
    }

    public void setPropertyDisplayNumbers(Boolean dn) {
        this.displayNumbers = dn;
        UpdateManager.markDirty(this);
    }

    public Boolean getPropertyDisplayNumbers() {
        return new Boolean(this.displayNumbers);
    }

    public String getShortDescriptionForDisplayNumbers() {
        return "Display numbers";
    }

    public String getLongDescriptionForDisplayNumbers() {
        return "Displays the permutation number for every city.";
    }

    public void setPropertyNumberColor(Color color) {
        if (color != null) {
            this.numberColor = color;
            UpdateManager.markDirty(this);
        }
    }

    public Color getPropertyNumberColor() {
        return this.numberColor;
    }

    public String getShortDescriptionForNumberColor() {
        return "Color of the numbers";
    }

    public String getLongDescriptionForNumberColor() {
        return "Sets the color for the displayed numbers.";
    }

    public void setPropertyPointColor(Color color) {
        if (color != null) {
            this.pointColor = color;
            UpdateManager.markDirty(this);
        }
    }

    public Color getPropertyPointColor() {
        return this.pointColor;
    }

    public String getShortDescriptionForPointColor() {
        return "Color of the points";
    }

    public String getLongDescriptionForPointColor() {
        return "Sets the color for the displayed city points.";
    }

    public void setPropertyLineColor(Color color) {
        if (color != null) {
            this.lineColor = color;
            UpdateManager.markDirty(this);
        }
    }

    public Color getPropertyLineColor() {
        return this.lineColor;
    }

    public String getShortDescriptionForLineColor() {
        return "Color of the lines";
    }

    public String getLongDescriptionForLineColor() {
        return "Sets the color for the displayed lines between the cities.";
    }

    class E2DPanel
    extends JPanel {
        private Insets insets;
        private int currentWidth;
        private int currentHeight;
        private double vertical;
        private double horizontal;
        private Graphics graphics;
        private EuclideanView eview;
        private int[] cycle;
        private double[][] points;
        private double[] borderRectangle;

        public E2DPanel(EuclideanView eview) {
            this.eview = eview;
            this.setBackground(Color.white);
            this.setBorder(BorderFactory.createEmptyBorder(25, 15, 15, 15));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            this.graphics = g;
            this.insets = this.getInsets();
            this.currentWidth = this.getWidth() - this.insets.left - this.insets.right;
            this.currentHeight = this.getHeight() - this.insets.top - this.insets.bottom;
            EuclideanView euclideanView = this.eview;
            synchronized (euclideanView) {
                TSP etsp = (TSP)this.eview.getSchedule().getRealFitnessFunction();
                this.points = etsp.getPoints();
                if (this.points != null) {
                    this.borderRectangle = etsp.getBorderRectangle();
                    this.vertical = (double)this.currentWidth / (this.borderRectangle[2] - this.borderRectangle[0]);
                    this.horizontal = (double)this.currentHeight / (this.borderRectangle[3] - this.borderRectangle[1]);
                    this.graphics.setColor(this.eview.lineColor);
                    Individual individual = EuclideanView.this.getIndividualToDisplay();
                    if (individual != null) {
                        Genotype geno = individual.getGenotype();
                        char[] fitness = (String.valueOf(etsp.getTSPName()) + ": " + Double.toString(0.0 - etsp.evaluate(geno))).toCharArray();
                        this.graphics.drawChars(fitness, 0, fitness.length, this.insets.left + 10, this.insets.top - 10);
                        this.cycle = ((PermutationGenotype)geno).getIntArray();
                        int i = 0;
                        while (i < this.points.length) {
                            this.drawLine(this.points[this.cycle[i] - 1][0], this.points[this.cycle[i] - 1][1], this.points[this.cycle[(i + 1) % this.cycle.length] - 1][0], this.points[this.cycle[(i + 1) % this.cycle.length] - 1][1]);
                            ++i;
                        }
                    }
                    int i = 0;
                    while (i < this.points.length) {
                        this.drawPoint(this.points[i][0], this.points[i][1], new Integer(i + 1).toString().toCharArray());
                        ++i;
                    }
                }
            }
        }

        private void drawLine(double x1, double y1, double x2, double y2) {
            this.graphics.drawLine(this.insets.left + (int)((x1 - this.borderRectangle[0]) * this.vertical), this.insets.top + (int)((y1 - this.borderRectangle[1]) * this.horizontal), this.insets.left + (int)((x2 - this.borderRectangle[0]) * this.vertical), this.insets.top + (int)((y2 - this.borderRectangle[1]) * this.horizontal));
        }

        private void drawPoint(double x, double y, char[] c) {
            this.graphics.setColor(this.eview.pointColor);
            this.graphics.fillOval(this.insets.left + (int)((x -= this.borderRectangle[0]) * this.vertical) - 1, this.insets.top + (int)((y -= this.borderRectangle[1]) * this.horizontal) - 1, 2, 2);
            if (this.eview.displayNumbers) {
                this.graphics.setColor(this.eview.numberColor);
                this.graphics.drawChars(c, 0, c.length, this.insets.left + (int)(x * this.vertical) + 2, this.insets.top + (int)(y * this.horizontal) + 10);
            }
        }
    }
}

