/*
 * Decompiled with CFR 0.152.
 */
package freak.module.searchspace.logictree;

import freak.module.searchspace.logictree.Data;
import freak.module.searchspace.logictree.OperatorNode;
import freak.module.searchspace.logictree.OperatorNodeVector;
import java.io.Serializable;

public abstract class MultipleOperatorNode
implements OperatorNode,
Serializable {
    protected OperatorNodeVector children;
    int numRows = -1;

    public abstract Object clone();

    public MultipleOperatorNode() {
        this.children = new OperatorNodeVector();
    }

    public MultipleOperatorNode(OperatorNodeVector childr) {
        int i = 0;
        while (i < childr.size()) {
            if (!(childr.get(i) instanceof OperatorNode)) {
                throw new RuntimeException("Vector childr contains Element that is not instance of OperatorNode");
            }
            ++i;
        }
        this.children = childr;
    }

    public int getNumberOfChildren() {
        return this.children.size();
    }

    OperatorNode getChildAt(int index) {
        if (index > this.children.size()) {
            return null;
        }
        if (!(this.children.get(index) instanceof OperatorNode)) {
            throw new RuntimeException("Vector children contains Element that is not instance of OperatorNode");
        }
        return this.children.get(index);
    }

    OperatorNode getRandomChild() {
        if (this.children.size() == 0) {
            return null;
        }
        int nr = Data.nextRandInt(this.children.size());
        return this.children.get(nr);
    }

    OperatorNodeVector getCopyOfChildren() {
        OperatorNodeVector rueckgabe = new OperatorNodeVector();
        int i = 0;
        while (i < this.children.size()) {
            rueckgabe.add((OperatorNode)this.children.get(i).clone());
            ++i;
        }
        return rueckgabe;
    }

    public boolean contains(OperatorNode on) {
        return this.children.contains(on);
    }

    void addChildrenVector(OperatorNodeVector onv) {
        this.children.addAll(onv);
    }

    public void addChild(OperatorNode child) {
        if (child == null) {
            return;
        }
        this.children.add(child);
    }

    public void deleteChild(OperatorNode child) {
        if (child == null) {
            return;
        }
        if (!this.children.contains(child)) {
            throw new IllegalArgumentException("Given OperatorNode is no child of this OrNode.");
        }
        this.children.remove(child);
    }

    public void deleteAllChildren() {
        this.children.removeAllElements();
    }

    void deleteRandomChild() {
        if (this.children.size() == 0) {
            return;
        }
        int nr = Data.nextRandInt(this.children.size());
        this.deleteChild(this.children.get(nr));
    }

    public int getSubtreeSize() {
        int rueckgabe = 0;
        int size = this.children.size();
        int i = 0;
        while (i < size) {
            rueckgabe += this.children.get(i).getSubtreeSize();
            ++i;
        }
        return rueckgabe;
    }

    public OperatorNodeVector getChildren() {
        return this.children;
    }

    public void updateBitset() {
        this.numRows = Data.getNumRows();
        int size = this.children.size();
        int i = 0;
        while (i < size) {
            this.children.get(i).updateBitset();
            ++i;
        }
    }
}

