/*
 * Decompiled with CFR 0.152.
 */
package freak.gui.scheduleeditor;

import freak.Freak;
import freak.core.control.Schedule;
import freak.core.fitness.FitnessFunction;
import freak.core.graph.Initialization;
import freak.core.modulesupport.AbstractBasicModule;
import freak.core.modulesupport.UnsupportedEnvironmentException;
import freak.core.populationmanager.PopulationManager;
import freak.core.searchspace.SearchSpace;
import freak.core.stoppingcriterion.StoppingCriterion;
import freak.core.util.StreamCopy;
import freak.gui.JButtonFactory;
import freak.gui.runframe.AbstractRunFrame;
import freak.gui.runframe.RunFrame;
import freak.gui.scheduleeditor.PanelBatches;
import freak.gui.scheduleeditor.PanelFitnessFunction;
import freak.gui.scheduleeditor.PanelGraph;
import freak.gui.scheduleeditor.PanelMapper;
import freak.gui.scheduleeditor.PanelObservers;
import freak.gui.scheduleeditor.PanelPopulation;
import freak.gui.scheduleeditor.PanelSearchSpace;
import freak.gui.scheduleeditor.PanelStoppingCriterion;
import freak.gui.scheduleeditor.ScheduleDependencyChecker;
import freak.gui.scheduleeditor.ScheduleEditorPanel;
import freak.gui.scheduleeditor.Util;
import freak.module.fitness.bitstring.OneMax;
import freak.module.operator.initialization.RandomInitialization;
import freak.module.populationmanager.DefaultPopulationManager;
import freak.module.searchspace.BitString;
import freak.rinterface.model.ScheduleConfigurator;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.NotSerializableException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class ScheduleEditor
extends JDialog {
    private static String RSaveTo = "schedule.freak";
    final int NUM_PANELS = 8;
    private AbstractRunFrame runFrame;
    private Schedule scheduleBackup;
    private Schedule schedule;
    private boolean newSchedule = true;
    private int phase;
    private ScheduleEditorPanel activePanel = null;
    private List phaseLabels = new ArrayList();
    private ScheduleDependencyChecker scheduleDependencyChecker;
    private boolean rMode = false;
    private JButton buBack;
    private JButton buCancel;
    private JButton buFinish;
    private JButton buHelp;
    private JButton buNext;
    private JLabel jLabel1;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JPanel jPanel14;
    private JLabel labelTitle;
    private JPanel panelButtons;
    private JPanel panelDesignLabels;
    private JPanel panelHelp;
    private JPanel panelSimulationLabels;
    private JTextField tfFitnessFunction;
    private JTextField tfGenotypeSearchSpace;
    private JTextField tfSearchSpace;

    public ScheduleEditor(AbstractRunFrame parent, Schedule aSchedule) {
        super(parent);
        this.initComponents();
        this.runFrame = parent;
        this.setSize(800, 550);
        this.setLocationRelativeTo(parent);
        this.initPanelLabels();
        this.scheduleDependencyChecker = new ScheduleDependencyChecker(this);
        if (aSchedule == null) {
            this.setupNewSchedule();
        } else {
            this.setupExistingSchedule(aSchedule);
        }
        this.updateComponents();
    }

    public void setRMode() {
        this.rMode = true;
    }

    public void resetRMode() {
        this.rMode = false;
    }

    public Schedule getSchedule() {
        return this.schedule;
    }

    public ScheduleDependencyChecker getScheduleDependencyChecker() {
        return this.scheduleDependencyChecker;
    }

    protected void updateComponents() {
        Util.displayText(this.tfSearchSpace, this.schedule.getPhenotypeSearchSpace() != null ? this.schedule.getPhenotypeSearchSpace().getName() : "<no search space selected>");
        Util.displayText(this.tfGenotypeSearchSpace, this.schedule.getGenotypeSearchSpace() != null ? this.schedule.getGenotypeSearchSpace().getName() : "<no mapper selected>");
        Util.displayText(this.tfFitnessFunction, this.schedule.getRealFitnessFunction() != null ? this.schedule.getRealFitnessFunction().getName() : "<no fitness function selected>");
        this.setupActivePhase();
    }

    private void setupNewSchedule() {
        this.labelTitle.setText("Create Schedule");
        this.setTitle("Create a new Schedule");
        this.schedule = new Schedule();
        this.scheduleDependencyChecker.setSchedule(this.schedule);
        ScheduleDependencyChecker.observerWarningAcknowledged = false;
        this.createDefaultSchedule();
        this.enterPhase(0);
    }

    private void setupExistingSchedule(Schedule aSchedule) {
        this.labelTitle.setText("Edit Schedule");
        this.setTitle("Edit a Schedule");
        this.scheduleBackup = aSchedule;
        try {
            this.schedule = (Schedule)StreamCopy.copy(aSchedule);
            this.scheduleDependencyChecker.setSchedule(this.schedule);
        }
        catch (NotSerializableException exc) {
            throw new RuntimeException(exc);
        }
        this.newSchedule = false;
        if (Util.scheduleStarted(this.schedule)) {
            this.enterPhase(this.phaseLabels.size() - 1);
        } else {
            this.enterPhase(0);
        }
    }

    private void addPhaseLabel(JLabel label, JPanel panel) {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = -1;
        constraints.fill = 2;
        constraints.insets = new Insets(0, 5, 8, 5);
        constraints.weightx = 1.0;
        panel.add((Component)label, constraints);
        this.phaseLabels.add(label);
    }

    private void initPanelLabels() {
        this.addPhaseLabel(new JLabel(String.valueOf(this.phaseLabels.size() + 1) + ". " + PanelSearchSpace.getDescription()), this.panelDesignLabels);
        this.addPhaseLabel(new JLabel(String.valueOf(this.phaseLabels.size() + 1) + ". " + PanelFitnessFunction.getDescription()), this.panelDesignLabels);
        this.addPhaseLabel(new JLabel(String.valueOf(this.phaseLabels.size() + 1) + ". " + PanelMapper.getDescription()), this.panelDesignLabels);
        this.addPhaseLabel(new JLabel(String.valueOf(this.phaseLabels.size() + 1) + ". " + PanelGraph.getDescription()), this.panelDesignLabels);
        this.addPhaseLabel(new JLabel(String.valueOf(this.phaseLabels.size() + 1) + ". " + PanelStoppingCriterion.getDescription()), this.panelDesignLabels);
        this.addPhaseLabel(new JLabel(String.valueOf(this.phaseLabels.size() + 1) + ". " + PanelPopulation.getDescription()), this.panelDesignLabels);
        this.addPhaseLabel(new JLabel(String.valueOf(this.phaseLabels.size() + 1) + ". " + PanelObservers.getDescription()), this.panelSimulationLabels);
        this.addPhaseLabel(new JLabel(String.valueOf(this.phaseLabels.size() + 1) + ". " + PanelBatches.getDescription()), this.panelSimulationLabels);
    }

    private ScheduleEditorPanel getPanelForPhase(int phase) {
        ScheduleEditorPanel panel = null;
        switch (phase) {
            case 0: {
                panel = new PanelSearchSpace(this);
                break;
            }
            case 1: {
                panel = new PanelFitnessFunction(this);
                break;
            }
            case 2: {
                panel = new PanelMapper(this);
                break;
            }
            case 3: {
                panel = new PanelGraph(this);
                break;
            }
            case 4: {
                panel = new PanelStoppingCriterion(this);
                break;
            }
            case 5: {
                panel = new PanelPopulation(this);
                break;
            }
            case 6: {
                panel = new PanelObservers(this);
                break;
            }
            case 7: {
                panel = new PanelBatches(this);
            }
        }
        if (panel != null) {
            GridBagConstraints gbc = new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0);
            this.getContentPane().add((Component)panel, gbc);
        }
        return panel;
    }

    private void setupActivePhase() {
        int i = 0;
        while (i < this.phaseLabels.size()) {
            JLabel label = (JLabel)this.phaseLabels.get(i);
            if (i == this.phase) {
                label.setFont(new Font("Dialog", 1, 12));
            } else {
                label.setFont(new Font("Dialog", 0, 12));
            }
            ++i;
        }
        this.buNext.setEnabled(this.phase != this.phaseLabels.size() - 1 && this.activePanel.mayAdvance());
        this.buBack.setEnabled(this.phase != 0);
        this.buFinish.setEnabled(this.scheduleDependencyChecker.isComplete());
    }

    private void enterPhase(int newPhase) {
        if (this.activePanel == null || newPhase < this.phase && !this.activePanel.stepBackVeto() || newPhase > this.phase && !this.activePanel.advanceVeto()) {
            ScheduleEditorPanel oldPanel = this.activePanel;
            this.activePanel = this.getPanelForPhase(newPhase);
            this.activePanel.enter();
            this.phase = newPhase;
            this.setupActivePhase();
            if (oldPanel != null) {
                oldPanel.setVisible(false);
                this.getContentPane().remove(oldPanel);
            }
        }
    }

    private void changePhaseTo(int newPhase) {
        if (newPhase < this.phase && this.activePanel.mayStepBack() || newPhase > this.phase && this.activePanel.mayAdvance()) {
            this.enterPhase(newPhase);
        }
    }

    private void finishEditing() {
        if (this.schedule.getBatchList().size() == 0) {
            this.scheduleDependencyChecker.createDefaultBatchList();
        }
    }

    private void createDefaultSchedule() {
        try {
            AbstractBasicModule m = new BitString(this.schedule);
            m.testSchedule(this.schedule);
            m.initialize();
            m.createEvents();
            this.schedule.setPhenotypeSearchSpace((SearchSpace)((Object)m));
            m = new OneMax(this.schedule);
            m.testSchedule(this.schedule);
            m.initialize();
            m.createEvents();
            this.schedule.setFitnessFunction((FitnessFunction)((Object)m));
            this.schedule.setStoppingCriteria(new StoppingCriterion[0]);
            m = new DefaultPopulationManager(this.schedule);
            m.testSchedule(this.schedule);
            m.initialize();
            m.createEvents();
            this.schedule.setPopulationManager((PopulationManager)((Object)m));
            this.scheduleDependencyChecker.createDefaultOperatorGraph();
            m = new RandomInitialization(this.schedule.getOperatorGraph());
            m.testSchedule(this.schedule);
            m.initialize();
            m.createEvents();
            ((Initialization)m).hideNameProperty();
            this.schedule.setInitialization((Initialization)m);
        }
        catch (UnsupportedEnvironmentException e) {
            throw new RuntimeException("Something is wrong with the default Schedule.", e);
        }
        this.scheduleDependencyChecker.createDefaultBatch();
    }

    private boolean isScheduleSetupCorrect() {
        return this.scheduleDependencyChecker.isComplete() && this.scheduleDependencyChecker.isCorrect();
    }

    private void initComponents() {
        this.panelHelp = new JPanel();
        this.labelTitle = new JLabel();
        this.jPanel14 = new JPanel();
        this.jLabel8 = new JLabel();
        this.tfSearchSpace = new JTextField();
        this.jLabel7 = new JLabel();
        this.tfFitnessFunction = new JTextField();
        this.jLabel1 = new JLabel();
        this.tfGenotypeSearchSpace = new JTextField();
        this.panelDesignLabels = new JPanel();
        this.panelSimulationLabels = new JPanel();
        this.panelButtons = new JPanel();
        this.buBack = JButtonFactory.newButton();
        this.buNext = JButtonFactory.newButton();
        this.buFinish = JButtonFactory.newButton();
        this.buHelp = JButtonFactory.newButton();
        this.buCancel = JButtonFactory.newButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Schedule Creation");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                ScheduleEditor.this.exitForm(evt);
            }
        });
        this.panelHelp.setLayout(new GridBagLayout());
        this.panelHelp.setMinimumSize(new Dimension(230, 400));
        this.panelHelp.setPreferredSize(new Dimension(230, 400));
        this.labelTitle.setFont(new Font("Dialog", 3, 22));
        this.labelTitle.setText("Schedule Creation");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.panelHelp.add((Component)this.labelTitle, gridBagConstraints);
        this.jPanel14.setLayout(new GridBagLayout());
        this.jPanel14.setBorder(new EtchedBorder());
        this.jLabel8.setText("Phenotype Search Space:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.jPanel14.add((Component)this.jLabel8, gridBagConstraints);
        this.tfSearchSpace.setEditable(false);
        this.tfSearchSpace.setText("<no search space selected>");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(0, 5, 10, 5);
        this.jPanel14.add((Component)this.tfSearchSpace, gridBagConstraints);
        this.jLabel7.setText("Fitness Function:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.jPanel14.add((Component)this.jLabel7, gridBagConstraints);
        this.tfFitnessFunction.setEditable(false);
        this.tfFitnessFunction.setText("<no fitness function selected>");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.jPanel14.add((Component)this.tfFitnessFunction, gridBagConstraints);
        this.jLabel1.setText("Genotype Search Space (Mapper)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.jPanel14.add((Component)this.jLabel1, gridBagConstraints);
        this.tfGenotypeSearchSpace.setEditable(false);
        this.tfGenotypeSearchSpace.setText("<no mapper selected>");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 10, 5);
        this.jPanel14.add((Component)this.tfGenotypeSearchSpace, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        this.panelHelp.add((Component)this.jPanel14, gridBagConstraints);
        this.panelDesignLabels.setLayout(new GridBagLayout());
        this.panelDesignLabels.setBorder(new TitledBorder("Design Algorithm"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        this.panelHelp.add((Component)this.panelDesignLabels, gridBagConstraints);
        this.panelSimulationLabels.setLayout(new GridBagLayout());
        this.panelSimulationLabels.setBorder(new TitledBorder("Prepare Simulation"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weighty = 0.1;
        this.panelHelp.add((Component)this.panelSimulationLabels, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.getContentPane().add((Component)this.panelHelp, gridBagConstraints);
        this.panelButtons.setLayout(new GridLayout(1, 0, 5, 0));
        this.buBack.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/navigation/Back16.gif")));
        this.buBack.setMnemonic('b');
        this.buBack.setText("Back");
        this.buBack.setEnabled(false);
        this.buBack.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ScheduleEditor.this.buBackActionPerformed(evt);
            }
        });
        this.panelButtons.add(this.buBack);
        this.buNext.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/navigation/Forward16.gif")));
        this.buNext.setMnemonic('n');
        this.buNext.setText("Next");
        this.buNext.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ScheduleEditor.this.buNextActionPerformed(evt);
            }
        });
        this.panelButtons.add(this.buNext);
        this.buFinish.setMnemonic('f');
        this.buFinish.setText("Finish");
        this.buFinish.setEnabled(false);
        this.buFinish.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ScheduleEditor.this.buFinishActionPerformed(evt);
            }
        });
        this.panelButtons.add(this.buFinish);
        this.buHelp.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Help16.gif")));
        this.buHelp.setMnemonic('h');
        this.buHelp.setText("Help");
        this.buHelp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ScheduleEditor.this.buHelpActionPerformed(evt);
            }
        });
        this.panelButtons.add(this.buHelp);
        this.buCancel.setText("Cancel");
        this.buCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ScheduleEditor.this.buCancelActionPerformed(evt);
            }
        });
        this.panelButtons.add(this.buCancel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        this.getContentPane().add((Component)this.panelButtons, gridBagConstraints);
        this.pack();
    }

    private void buHelpActionPerformed(ActionEvent evt) {
        this.runFrame.showHelpPage(this.activePanel.getHelpURL());
    }

    private void buFinishActionPerformed(ActionEvent evt) {
        this.ok();
    }

    private void buBackActionPerformed(ActionEvent evt) {
        this.changePhaseTo(this.phase - 1);
    }

    private void buNextActionPerformed(ActionEvent evt) {
        this.changePhaseTo(this.phase + 1);
    }

    public void ok() {
        if (this.isScheduleSetupCorrect()) {
            this.finishEditing();
            this.dispose();
            this.runFrame.editorClosed();
            if (this.rMode) {
                ScheduleConfigurator.setCurrentSchedule(this.schedule);
                try {
                    ((RunFrame)this.runFrame).runControl.toFile().write(new FileOutputStream(new File(RSaveTo)));
                }
                catch (Exception exc) {
                    throw new RuntimeException(exc);
                }
                if (Freak.isCircumventR()) {
                    System.exit(0);
                }
            }
        }
    }

    public void cancel() {
        this.schedule = null;
        this.runFrame.editorClosed();
        this.dispose();
    }

    private void buCancelActionPerformed(ActionEvent evt) {
        this.cancel();
    }

    private void exitForm(WindowEvent evt) {
        this.cancel();
    }

    public static void setRSaveTo(String saveTo) {
        RSaveTo = saveTo;
    }
}

