% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rforcecom.getBulkQueryResult.R
\name{rforcecom.getBulkQueryResult}
\alias{rforcecom.getBulkQueryResult}
\title{Retrieving the Results of a Bulk Query Batch in a Bulk API Job}
\usage{
rforcecom.getBulkQueryResult(session, jobId, batchId, resultId)
}
\arguments{
\item{session}{a named character vector defining parameters of the api connection as returned by \link{rforcecom.login}}

\item{jobId}{a character string defining the salesforce id assigned to a submitted job as returned by \link{rforcecom.createBulkJob}}

\item{batchId}{a character string defining the salesforce id assigned to a submitted batch as returned by \link{rforcecom.createBulkBatch}}

\item{resultId}{a character string returned from \link{rforcecom.getBatchDetails} when a query has completed and specifies how to get the recordset}
}
\value{
A \code{data.frame}, formatted by salesforce, containing query results
}
\description{
This function returns the resultset of a Bulk Query batch
which has already been submitted to Bulk API Job and has Completed state
}
\examples{
\dontrun{
result <- rforcecom.getBatchDetails(session, 
                                    jobId=batch_query_info$jobId, 
                                    batchId=batch_query_info$id)
recordset <- rforcecom.getBulkQueryResult(session, 
                                          jobId=batch_query_info$jobId, 
                                          batchId=batch_query_info$id, 
                                          resultId=result$result)
}
}
\references{
\url{https://developer.salesforce.com/docs/atlas.en-us.api_asynch.meta/api_asynch/}
}
\concept{
bulk batch salesforce api
}

