% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rforcecom.createBulkBatch.R
\name{rforcecom.createBulkBatch}
\alias{rforcecom.createBulkBatch}
\title{Create and Add Batches to a Bulk API Job}
\usage{
rforcecom.createBulkBatch(session, jobId, data, multiBatch=TRUE, batchSize=10000)
}
\arguments{
\item{session}{a named character vector defining parameters of the api connection as returned by \link{rforcecom.login}}

\item{jobId}{a character string defining the salesforce id assigned to a submitted job as returned by \link{rforcecom.createBulkJob}}

\item{data}{a matrix or data.frame that can be coerced into .csv file for submitting as batch request}

\item{multiBatch}{a boolean value defining whether or not submit data in batches to the api}

\item{batchSize}{an integer value defining the number of records to submit if multiBatch is true. 
The max value is 10000 in accordance with salesforce limits.}
}
\value{
A \code{list} of \code{list}s, one for each batch submitted, containing 10 parameters of the batch
}
\description{
This function takes a data frame and submits it in batches to a 
an already existing Bulk API Job by chunking into temp files
}
\examples{
\dontrun{

# inserting 2 records
my_data <- data.frame(Name=c('New Record 1', 'New Record 2'), 
                      My_External_Id__c=c('11111','22222'), 
                      stringsAsFactors=FALSE)
batches_info <- rforcecom.createBulkBatch(session, 
                                          jobId=job_info$id, 
                                          data=my_data, 
                                          multiBatch=TRUE, 
                                          batchSize=50)
#upserting 3 records
my_data <- data.frame(My_External_Id__c=c('11111','22222', '99999'), 
                      Name=c('Updated_Name1', 'Updated_Name2', 'Upserted_Record'), 
                      stringsAsFactors=FALSE)
batches_info <- rforcecom.createBulkBatch(session, 
                                          jobId=job_info$id, 
                                          data=my_data, 
                                          multiBatch=TRUE, 
                                          batchSize=50)
}
}
\references{
\url{https://developer.salesforce.com/docs/atlas.en-us.api_asynch.meta/api_asynch/}
}
\concept{
bulk batch salesforce api
}

