% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backCalc.R
\name{backCalc}
\alias{backCalc}
\title{Back-calculate length at previous ages from standard data format.}
\usage{
backCalc(
  dat,
  lencap,
  BCM,
  inFormat,
  outFormat = inFormat,
  a = NULL,
  L0p = NULL,
  R0p = NULL,
  L0 = NULL,
  R0 = NULL,
  deletePlusGrowth = TRUE,
  digits = getOption("digits")
)
}
\arguments{
\item{dat}{A data.frame created with \code{\link{combineData}} that MUST have at least the length-at-capture appended as a variable. See Details.}

\item{lencap}{The unquoted name of the length-at-capture variable.}

\item{BCM}{A single numeric between 1 and 22 or a string that indicates which model to use (based on numbers and names in Vigliola and Meekan (2009)). See Details in \code{\link{bcFuns}} for the list of available models.}

\item{inFormat}{The format of the data in \code{dat}. The two choices are \code{"long"} with one radial measurement per line (and all radial measurements for a fish in separate rows) and \code{"wide"} with one fish per line (and all radial measurements in separate variables). Defaults to \code{"long"}.}

\item{outFormat}{The format for the returned data.frame. Choices are as described for \code{inFormat}. Defaults to be the same as \code{inFormat}.}

\item{a}{The fish length when the structure first forms as used in the Fraser-Lee model (i.e., \code{BCM=1} or \code{BCM="FRALE"}). If this is missing then \code{a} will be estimated as the intercept from the fish length on structure radius linear regression.}

\item{L0p}{The length at the \dQuote{Biological Intercept} point. Only used in the \dQuote{Biological Intercept} (\code{BCM=3}), \dQuote{Watanabe and Kuroki} (\code{BCM=12}), and \dQuote{Modified Fry} (\code{BCM=14}) models.}

\item{R0p}{The stucture radius at the \dQuote{Biological Intercept} point. Only used in the \dQuote{Biological Intercept} (\code{BCM=3}), \dQuote{Watanabe and Kuroki} (\code{BCM=12}), and \dQuote{Modified Fry} (\code{BCM=14}) models.}

\item{L0}{The length at the arbitrarily selected point in the \dQuote{Fry} (\code{BCM=13}) model.}

\item{R0}{The structure radius at the arbitrarily selected point in the \dQuote{Fry} (\code{BCM=13}) model.}

\item{deletePlusGrowth}{A logical that indicates whether the radial measurement that corresponds to \dQuote{plus-growth} on the structure should be deleted (\code{TRUE}; Default) or not (\code{FALSE}).}

\item{digits}{Number of digits to which the back-calculated lengths should be rounded. Defaults to the value returned by \code{getOptions("digits")}, which is generally 7 digits.}
}
\value{
A data.frame similar to \code{dat} but with the radial measurements replaced by back-calculated lengths at previous ages.
}
\description{
Back-calculates length at previous ages from a data.frame that was primarily created from \code{\link{combineData}} and \code{\link{digitizeRadii}}. One of several back-calculation models, described in \code{\link{bcFuns}} and Vigliola and Meekan (2009), can be used. Parameter estimates from various models of fish length on structure radius or structure radius on fish length are computed internally and used in the back-calculations. This function is intended to make back-calculation of fish length at previous ages as streamlined as possible.
}
\examples{
## None yet.

}
