% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_s3_rendocopulacorrection.R
\name{summary.rendo.copula.correction}
\alias{summary.rendo.copula.correction}
\title{Summarizing Bootstrapped copulaCorrection Model Fits}
\usage{
\method{summary}{rendo.copula.correction}(object, ...)
}
\arguments{
\item{object}{an object of class \code{rendo.copula.correction}, a result of a call to \code{copulaCorrection}.}

\item{...}{ignored, for consistency with the generic function.}
}
\value{
The function computes and returns a list of summary statistics which contains the following components:

\item{coefficients}{a \code{px4} matrix with columns for the estimated coefficients for the the original data, the standard error derived from the bootstrapped parameters,
and the lower and upper boundaries of the 95\% bootstrap confidence interval.}
\item{num.boots}{the number of bootstraps performed.}
\item{names.main.coefs}{a vector specifying which coefficients are from the model. For internal usage.}
\item{start.params}{a named vector with the initial set of parameters used to optimize the log-likelihood function.}
\item{vcov}{variance covariance matrix derived from the bootstrapped parameters.}
\item{names.vars.continuous}{the names of the continuous endogenous regressors.}
\item{names.vars.discrete}{the names of the discrete endogenous regressors.}

For the case of a single continuous endogenous regressor, also the following components
resulting from the log-likelihood optimization are returned:
\item{AIC}{Akaike's An Information Criterion for the model fitted on the provided data.}
\item{BIC}{Schwarz's Bayesian Criterion for the model fitted on the provided data.}
\item{KKT1}{first Kuhn, Karush, Tucker optimality condition as returned by optimx.}
\item{KKT2}{second Kuhn, Karush, Tucker optimality condition as returned by optimx.}
\item{conv.code}{the convergence code as returned by optimx.}
\item{log.likelihood}{the value of the log-likelihood function at the found solution for the provided data.}
}
\description{
\code{summary} method for a model of class \code{rendo.copula.correction} resulting from fitting \code{copulaCorrection}.
}
\details{
For a single continuous endogenous regressor, the estimation is realized in two steps by first obtaining the
empirical distribution of the endogenous regressor and then the likelihood function is built. Also for all
other cases the estimation is realized in two steps and hence the standard errors reported by the
fitted OLS model are not correct.

The standard errors and the confidence intervals are therefore obtained using bootstrapping with replacement as
described in Effron (1979). The reported lower and upper boundaries are from the 95\% bootstrapped percentile
confidence interval. If there are too few bootstrapped estimates, no boundaries are reported.

For a single continuous endogenous regressor the model was fitted using maximum likelihood optimization. The
related goodness of fit measures and convergence indicators are also reported here.
}
\references{
Effron, B.(1979). "Bootstrap Methods: Another Look at the Jackknife", The Annals of Statistics, 7(1), 1-26.
}
\seealso{
The model fitting function \code{\link[REndo:copulaCorrection]{copulaCorrection}}

\code{\link[REndo:confint.rendo.boots]{confint}} for how the confidence intervals are derived

\code{\link[REndo:vcov.rendo.boots]{vcov}} for how the variance-covariance matrix is derived

\code{\link[optimx:optimx]{optimx}} for explanations about the returned \code{conv.code} and \code{KKT}.

Function \code{coef} will extract the \code{coefficients} matrix and
function \code{vcov} will extract the component \code{vcov} from the returned summary object.
}
