% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cop_bootsSE.R
\name{boots}
\alias{boots}
\title{Bootstrapping Standard Errors}
\usage{
boots(bot, formula, endoVar, param, intercept = NULL, data)
}
\arguments{
\item{bot}{number of bootstrap replicates.}

\item{formula}{the model formula, e.g. \code{y ~ X1 + X2 + P}.}

\item{endoVar}{a string with the name of the endogenous variable/s, in quotation marks.}

\item{param}{initial values for the parameters to be optimized over. See \code{\link{copulaCorrection}} for more details.}

\item{intercept}{an optional parameter. The model is estimated by default with 
intercept. If no intercept is desired in model estimation, intercept should be given the value "FALSE", otherwise the value "TRUE".}

\item{data}{a data frame or matrix containing the variables of the model.}
}
\value{
Returns the standard errors of the estimates of the model using the copula method 1 described in Park and Gupta (2012). See Details section of \code{\link{copulaCorrection}}.
}
\description{
Performs bootstrapping to obtain the standard errors of the estimates of the model with one continuous endogenous regressor estimated via maximum likelihood
using the \code{\link{copulaCorrection}} function.
}
\details{
The function could be used only when there is a single endogenous regressor and method one is selected in \code{\link{copulaCorrection}}.
of the \code{copulaCorrection} function is used for estimation.
}
\seealso{
\code{\link{copulaCorrection}}
}
