% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_table.R
\name{extract_tables}
\alias{extract_tables}
\title{Extract one or more tibbles from a REDCapTidieR supertibble}
\usage{
extract_tables(.data, tbls = everything())
}
\arguments{
\item{.data}{A tibble generated by \code{read_redcap_tidy()}. Required.}

\item{tbls}{A vector of \code{form_name}s or a tidy selector. Default is
\code{everything()}.}
}
\value{
A named list of \code{tibble}s
}
\description{
Take a supertibble generated with \code{read_redcap_tidy()}
and return a named list of tibbles.
}
\details{
This function makes it easy to extract a multiple instrument's data from a
REDCapTidieR supertibble into a named list. Specifying instruments using
\code{tidyselect} semantics such as \code{starts_with()}
or \code{ends_with()} is supported.
}
\examples{
# Supply a `read_redcap_tidy()` output to for table extraction

# Default `everything()`
sample_data <- tibble::tribble(
   ~redcap_form_name,    ~redcap_data, ~structure,
   "super_hero_powers",   list(),       "repeating",
   "heroes_information",  list(),       "nonrepeating"
)

extract_tables(sample_data)

extract_tables(sample_data, starts_with("heroes"))

}
