% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Pmix.R
\name{Pmix}
\alias{Pmix}
\title{Poisson mixture estimation via Kiefer Wolfowitz MLE}
\usage{
Pmix(x, v = 300, exposure = NULL, ...)
}
\arguments{
\item{x}{Data: Sample observations (integer valued)}

\item{v}{Grid Values for the mixing distribution defaults to equal
spacing of length v when v is specified as a scalar}

\item{exposure}{observation specific exposures to risk see details}

\item{...}{other parameters passed to KWDual to control optimization}
}
\value{
An object of class density with components: 
	\item{x}{points of evaluation of the mixing density} 
	\item{y}{function values of the mixing density at x} 
	\item{g}{function values of the mixture density on \eqn{0, 1, ... max(x)+1}} 
	\item{logLik}{Log Likelihood value at the estimate} 
	\item{dy}{Bayes rule estimate of Poisson rate parameter at each x}  
\item{status}{exit code from the optimizer}
}
\description{
Poisson mixture estimation via Kiefer Wolfowitz MLE
}
\details{
The predict method for \code{Pmix} objects will compute means, medians or
modes of the posterior according to whether the \code{Loss} argument is 2, 1
or 0, or posterior quantiles if \code{Loss} is in (0,1).

 In the default case \code{exposure = 1} it is assumed that
\code{x} contains individual observations that are aggregated into
count bins via \code{table}.  When \code{exposure} has the same length as
code{x} then it is presumed to be individual specific risk exposure and
the Poisson mixture is taken to be \eqn{x | v ~ Poi(v * exposure)} and the
is not aggregated.  See for example the analysis of the Norberg data in
Koenker and Gu (2016).
}
\references{
Kiefer, J. and J. Wolfowitz Consistency of the Maximum
Likelihood Estimator in the Presence of Infinitely Many Incidental
Parameters \emph{Ann. Math. Statist}. Volume 27, Number 4 (1956), 887-906.

Koenker R. and J. Gu (2016) "REBayes:  An R Package for Empirical Bayes Mixture Methods"
}
\author{
Roger Koenker and Jiaying Gu
}
\keyword{nonparametric}
