% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/WGLVmix.R
\name{WGLVmix}
\alias{WGLVmix}
\title{Weighted NPMLE ofLongitudinal Gaussian Mean and Variances Model}
\usage{
WGLVmix(y, id, w, u = 30, v = 30, ...)
}
\arguments{
\item{y}{A vector of observations}

\item{id}{A strata indicator vector of the same length}

\item{w}{A vector of weights}

\item{u}{A vector of bin boundaries for the mean effects}

\item{v}{A vector of bin boundaries for the variance effects}

\item{...}{optional parameters to be passed to KWDual to control optimization}
}
\value{
A list consisting of the following components:
	\item{u}{midpoints of mean bin boundaries}
	\item{v}{midpoints of variance bin boundaries}
	\item{fuv}{the function values of the mixing density.}
	\item{logLik}{log likelihood value for mean problem}
	\item{du}{Bayes rule estimate of the mixing density means.}
	\item{dv}{Bayes rule estimate of the mixing density variances.}
	\item{status}{Mosek convergence status}
}
\description{
A Kiefer-Wolfowitz procedure for ML estimation of a Gaussian model with
dependent mean and variance components and weighted longitudinal data.
This version assumes a general bivariate distribution for the mixing
distribution. The defaults use a rather coarse bivariate gridding.
}
\author{
R. Koenker and J. Gu
}
\references{
Gu, J. and R. Koenker (2014) Heterogeneous Income Dynamics: An
Empirical Bayes Perspective, \emph{JBES}, forthcoming.
}
\seealso{
WTLVmix for an implementation assuming independent heterogeneity
}
\keyword{nonparametric}

