% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rxiv.R
\name{Rxiv}
\alias{Rxiv}
\title{Archive function for auxiliary files for latex documents}
\usage{
Rxiv(fname, figures = "figures", tables = "tables", tar = FALSE)
}
\arguments{
\item{fname}{name of the latex file of the paper sans .tex suffix}

\item{figures}{name of the directory with the files for figures}

\item{tables}{name of the directory with the files for tables}

\item{tar}{logical flag, if TRUE generate a gzipped tar file of .R files}
}
\value{
a list with the following components
\item{Rtables}{a character array with two columns:  .tex files and .R files}
\item{Rfigures}{a character array with two columns:  .pdf files and .R files}
\item{Rother}{a character vector with other R files required.}
\item{Rcached}{a character vector with cached Rda files}
}
\description{
Creates a tar.gz file with all of the R files needed to recreate the tables
and figures that appear in the paper.  Should be considered experimental at
this stage.  It presumes that tables are generated with something like the
\pkg{Hmisc}  \code{latex} function and included in the latex document with
\code{input} commands.  Likewise figures are assumed to be included with
\code{includegraphics} and generated by R in pdf format.  This
was originally developed to sort out the files for "Empirical Bayesball Remixed".
An optional side of effect of the function to create a tar.gz file with the gzipped
R files required for the paper.
}
\author{
R. Koenker
}

