% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prog.R
\name{PhaseTimeRange}
\alias{PhaseTimeRange}
\title{Phase Time Range}
\usage{
PhaseTimeRange(PhaseBeginning_chain, PhaseEnd_chain, level = 0.95,
  max_decimal = 2)
}
\arguments{
\item{PhaseBeginning_chain}{numeric vector containing the output of the MCMC algorithm for the beginning of the phase}

\item{PhaseEnd_chain}{numeric vector containing the output of the MCMC algorithm for the end of the phase}

\item{level}{probability corresponding to the desired level of confidence}

\item{max_decimal}{maximum number of decimal}
}
\value{
A vector of values containing the desired level of confidence and the endpoints of the shortest time range associated with this desired level
}
\description{
Computes the shortest interval [IntervalInf ; IntervalSup ] that satisfies : P(Phase1End < IntervalInf < IntervalSup < Phase2Beginning | M) = level
}
\examples{

  data(Phases); attach(Phases)
  PhaseTimeRange(Phase.1.alpha, Phase.1.beta, 0.95)
  PhaseTimeRange(Phase.2.alpha, Phase.2.beta, 0.95, 0)

}
\keyword{ phase time range}

