% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03_IFE_algorithm_functions.R
\name{initialise_clustering}
\alias{initialise_clustering}
\title{Function that clusters time series in a dataframe with kmeans.}
\usage{
initialise_clustering(
  Y,
  S,
  k,
  kg,
  comfactor,
  robust,
  max_percent_outliers_tkmeans = 0,
  verbose = FALSE
)
}
\arguments{
\item{Y}{Y: NxT dataframe with the panel data of interest}

\item{S}{the desired number of groups}

\item{k}{number of common factors to be estimated}

\item{kg}{number of group specific factors to be estimated}

\item{comfactor}{estimated common factors}

\item{robust}{TRUE or FALSE: defines using the classical or robust algorithm to estimate beta}

\item{max_percent_outliers_tkmeans}{the proportion of observations to be trimmed}

\item{verbose}{when TRUE, it prints messages}
}
\value{
numeric vector
}
\description{
If a time series contains NA's a random cluster will be assigned to that time series.
}
\examples{
Y <- Y_dgp3
comfactor <- matrix(0, nrow = ncol(Y))
initialise_clustering(Y, 3, 0, c(3, 3, 3), comfactor, TRUE)
}
