% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-gene-heatmap.R
\name{plotDEGeneHeatmap}
\alias{plotDEGeneHeatmap}
\title{Plot gene heatmap from a SummarizedExperiment object with DE analysis results}
\usage{
plotDEGeneHeatmap(
  DEResults,
  genes,
  useFDR = TRUE,
  labels = NULL,
  logFCLims = c(-5, 5),
  negLog10pValueLims = c(0, 5)
)
}
\arguments{
\item{DEResults}{A named list of data frame of DE analysis results.}

\item{genes}{A vector of gene id (e.g. Entrez IDs) to plot.
The genes must be in the ID column of the data frame in DEResults.}

\item{useFDR}{If TRUE, use FDR adjusted p-values. Otherwise, use raw p-values.}

\item{labels}{A vector of labels for the genes. If not provided, the gene IDs will be used as labels.}

\item{logFCLims}{A vector of length 2 specifying the minimum and maximum log fold change to plot.}

\item{negLog10pValueLims}{A vector of length 2 specifying the minimum and maximum -log10(p-value) to plot.}
}
\value{
A heatmap of the genes from ggplot2.
}
\description{
Plot gene heatmap from a SummarizedExperiment object with DE analysis results.
The heatmap contains p-values and log fold changes from the DE analysis.
}
\examples{
\donttest{
library(RCPA)
library(SummarizedExperiment)

affyDEExperiment <- loadData("affyDEExperiment")
agilDEExperiment <- loadData("agilDEExperiment")
RNASeqDEExperiment <- loadData("RNASeqDEExperiment")
genesets <- loadData("genesets")

DEResults <- list(
    "Affymetrix - GSE5281" = rowData(affyDEExperiment),
    "Agilent - GSE61196" = rowData(agilDEExperiment),
    "RNASeq - GSE153873" = rowData(RNASeqDEExperiment)
)

# Install the meta package if not installed
# if (!requireNamespace("meta", quietly = TRUE)) {
#     install.packages("meta")
# }

if (requireNamespace("meta", quietly = TRUE)) {
    metaDEResult <- RCPA::runDEMetaAnalysis(DEResults, method = "stouffer")
    metaDEResult <- metaDEResult[order(metaDEResult$pFDR),]

    alzheimerGenes <- genesets$genesets[["path:hsa05010"]]
    genesToPlot <- head(metaDEResult[metaDEResult$ID \%in\% alzheimerGenes, ], 50)$ID

    genesAnnotation <- RCPA::getEntrezAnnotation(genesToPlot)
    labels <- genesAnnotation[genesToPlot, "Description"]

    genesOrderByFC <- order(metaDEResult[match(genesToPlot, metaDEResult$ID), "logFC"])
    resultsToPlot <- c(DEResults, list(metaDEResult))
    names(resultsToPlot) <- c(names(DEResults), "Meta-analysis")

    RCPA::plotDEGeneHeatmap(
        resultsToPlot,
        genesToPlot[genesOrderByFC],
        labels = labels[genesOrderByFC],
        negLog10pValueLims = c(0, 5), logFCLims = c(-1, 1)
    )
}

}
}
