% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mix.R
\name{mix}
\alias{mix}
\alias{dmix}
\alias{pmix}
\alias{qmix}
\alias{rmix}
\alias{[[.mix}
\title{Mixture Distributions}
\usage{
dmix(mix, x, log = FALSE)

pmix(mix, q, lower.tail = TRUE, log.p = FALSE)

qmix(mix, p, lower.tail = TRUE, log.p = FALSE)

rmix(mix, n)

\method{[[}{mix}(mix, ..., rescale = FALSE)
}
\arguments{
\item{mix}{mixture distribution object}

\item{x, q}{vector of quantiles}

\item{log, log.p}{logical; if \code{TRUE} (not default), probabilities \eqn{p} are given as \eqn{\log(p)}}

\item{lower.tail}{logical; if \code{TRUE} (default), probabilities are \eqn{P[X\leq x]} otherwise, \eqn{P[X>x]}}

\item{p}{vector of probabilities}

\item{n}{number of observations. If \code{length(n) > 1}, the length is taken to be the number
required}

\item{...}{components to subset given mixture.}

\item{rescale}{logical; if \code{TRUE}, mixture weights will be rescaled to sum to 1}
}
\value{
\code{dmix} gives the weighted sum of the densities of each
component.

\code{pmix} calculates the distribution function by
evaluating the weighted sum of each components distribution
function.

\code{qmix} returns the quantile for the given \code{p}
by using that the distribution function is monotonous and hence a
gradient based minimization scheme can be used to find the matching
quantile \code{q}.

\code{rmix} generates a random sample of size
\code{n} by first sampling a latent component indicator in the
range \eqn{1..K} for each draw and then the function samples from
each component a random draw using the respective sampling
function. The \code{rnorm} function returns the random draws as
numerical vector with an additional attribute \code{ind} which
gives the sampled component indicator.
}
\description{
Density, cumulative distribution function, quantile
function and random number generation for supported mixture
distributions.  (d/p/q/r)mix are generic and work with any mixture
supported by BesT (see table below).
}
\details{
A mixture distribution is defined as a linear
superposition of \eqn{K} densities of the same distributional
class. The mixture distributions supported have the form

\deqn{f(x,\mathbf{w},\mathbf{a},\mathbf{b}) = \sum_{k=1}^K w_k \, f_k(x,a_k,b_k).}{f(x,w,a,b) = \sum_{k=1}^K w_k * f(x,a_k,b_k).}

The \eqn{w_k} are the mixing coefficients which must sum to
\eqn{1}. Moreover, each density \eqn{f} is assumed to be
parametrized by two parameters such that each component \eqn{k} is
defined by a triplet, \eqn{(w_k,a_k,b_k)}.

Individual mixture components can be extracted using the \code{[[}
operator, see examples below.

The supported densities are normal, beta and gamma which can be
instantiated with \code{\link{mixnorm}}, \code{\link{mixbeta}}, or
\code{\link{mixgamma}}, respectively. In addition, the respective
predictive distributions are supported. These can be obtained by
calling \code{\link{preddist}} which returns appropriate normal,
beta-binomial or Poisson-gamma mixtures.

For convenience a \code{summary} function is defined for all
mixtures. It returns the mean, standard deviation and the requested
quantiles which can be specified with the argument \code{probs}.
}
\section{Supported Conjugate Prior-Likelihood Pairs}{


\tabular{lccc}{
\strong{Prior/Posterior} \tab \strong{Likelihood} \tab \strong{Predictive} 
 \tab \strong{Summaries} \cr
Beta \tab Binomial \tab Beta-Binomial \tab \code{n}, \code{r} \cr
Normal \tab Normal (\emph{fixed \eqn{\sigma}}) \tab Normal \tab \code{n}, \code{m}, \code{se}  \cr
Gamma \tab Poisson \tab Gamma-Poisson \tab  \code{n}, \code{m} \cr
Gamma \tab Exponential \tab Gamma-Exp (\emph{not supported}) \tab \code{n}, \code{m}
}
}

\examples{
## a beta mixture
bm <- mixbeta(weak = c(0.2, 2, 10), inf = c(0.4, 10, 100), inf2 = c(0.4, 30, 80))

## extract the two most informative components
bm[[c(2, 3)]]
## rescaling needed in order to plot
plot(bm[[c(2, 3), rescale = TRUE]])

summary(bm)

}
\seealso{
\code{\link{plot.mix}}

Other mixdist: 
\code{\link{mixbeta}()},
\code{\link{mixcombine}()},
\code{\link{mixgamma}()},
\code{\link{mixmvnorm}()},
\code{\link{mixnorm}()},
\code{\link{mixplot}}
}
\concept{mixdist}
