% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixgamma.R
\name{mixgamma}
\alias{mixgamma}
\alias{ms2gamma}
\alias{mn2gamma}
\alias{print.gammaMix}
\alias{print.gammaPoissonMix}
\alias{print.gammaExpMix}
\alias{summary.gammaMix}
\alias{summary.gammaPoissonMix}
\title{The Gamma Mixture Distribution}
\usage{
mixgamma(..., param = c("ab", "ms", "mn"), likelihood = c("poisson", "exp"))

ms2gamma(m, s, drop = TRUE)

mn2gamma(m, n, likelihood = c("poisson", "exp"), drop = TRUE)

\method{print}{gammaMix}(x, ...)

\method{print}{gammaPoissonMix}(x, ...)

\method{print}{gammaExpMix}(x, ...)

\method{summary}{gammaMix}(object, probs = c(0.025, 0.5, 0.975), ...)

\method{summary}{gammaPoissonMix}(object, probs = c(0.025, 0.5, 0.975), ...)
}
\arguments{
\item{...}{List of mixture components.}

\item{param}{Determines how the parameters in the list are
interpreted. See details.}

\item{likelihood}{Defines with what likelihood the Gamma density is used (Poisson or Exp). Defaults to \code{poisson}.}

\item{m}{Vector of means of the Gamma mixture components}

\item{s}{Vector of standard deviations of the gamma mixture components,}

\item{drop}{Delete the dimensions of an array which have only one level.}

\item{n}{Vector of sample sizes of the Gamma mixture components.}

\item{x}{The mixture to print}

\item{object}{Gamma mixture object.}

\item{probs}{Quantiles reported by the \code{summary} function.}
}
\value{
\code{mixgamma} returns a gamma mixture with the specified mixture components.
\code{ms2gamma} and
\code{mn2gamma} return the equivalent natural \code{a} and \code{b} parametrization given
parameters \code{m}, \code{s}, or \code{n}.
}
\description{
The gamma mixture density and auxiliary functions.
}
\details{
Each entry in the \code{...} argument list is expected to
be a triplet of numbers which defines the weight \eqn{w_k}, first
and second parameter of the mixture component \eqn{k}. A triplet
can optionally be named which will be used appropriately.

The first and second parameter can be given in different
parametrizations which is set by the \code{param} option:
\describe{
\item{ab}{Natural parametrization of Gamma density (\code{a}=shape and \code{b}=rate). Default. }
\item{ms}{Mean and standard deviation, \eqn{m=a/b} and \eqn{s=\sqrt{a}/b}.}
\item{mn}{Mean and number of observations. Translation to natural
parameter depends on the \code{likelihood} argument. For a Poisson
likelihood \eqn{n=b} (and \eqn{a=m \cdot n}{a=m n}), for an Exp
likelihood \eqn{n=a} (and \eqn{b=n/m}).}
}
}
\examples{
# Gamma mixture with robust and informative component
gmix <- mixgamma(rob=c(0.3, 20, 4), inf=c(0.7, 50, 10))

# objects can be printed
gmix
# or explicitly
print(gmix)

# summaries are defined
summary(gmix)

# sub-components may be extracted
# by component number
gmix[[2]]
# or component name
gmix[["inf"]]

# alternative mean and standard deviation parametrization
gmsMix <- mixgamma(rob=c(0.5, 8, 0.5), inf=c(0.5, 9, 2), param="ms")

# or mean and number of observations parametrization
gmnMix <- mixgamma(rob=c(0.2, 2, 1), inf=c(0.8, 2, 5), param="mn")

# and mixed parametrizations are also possible
gfmix <- mixgamma(rob1=c(0.15, mn2gamma(2, 1)), rob2=c(0.15, ms2gamma(2, 5)), inf=c(0.7, 50, 10))
}
\seealso{
Other mixdist: 
\code{\link{mixbeta}()},
\code{\link{mixcombine}()},
\code{\link{mixmvnorm}()},
\code{\link{mixnorm}()},
\code{\link{mixplot}},
\code{\link{mix}}
}
\concept{mixdist}
