% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RBMRB.R
\name{fetch_res_chemical_shifts}
\alias{fetch_res_chemical_shifts}
\title{Fetchs residue specific NMR chemical shift data from BMRB database}
\usage{
fetch_res_chemical_shifts(res = "*", atm = "*")
}
\arguments{
\item{res}{residue name in NMR-STAR atom nomenclature ; Example: ALA,GLY ; default '*' (includes everything)}

\item{atm}{atom name in NMR-STAR nomenclautre ; Example :CA,HB2; default * (includes all atoms)}
}
\value{
R data frame that contains full chemical shift list for a given atom
}
\description{
Downloads the full list of chemical shifts from BMRB macromolecular database for a given amino acid (or) nucleic acid. Optionally particular atom can be specified in the parameter
}
\examples{
#df<-fetch_res_chemical_shifts('GLY')
# Downloads chemical shift data of all atoms of GLY
#df<-fetch_res_chemical_shifts('ALA','CA')
# Downloads C alpha chemical shifts of ALA from macromolecules database at BMRB
}
\seealso{
\code{\link{fetch_atom_chemical_shifts}},\code{\link{filter_residue}} and \code{\link{chemical_shift_hist}}
}

