% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_Aa_optimal_known_var.r
\name{sim_Aa_optimal_known_var}
\alias{sim_Aa_optimal_known_var}
\title{Simulate a Trial Using Aa-Optimal Allocation for Continuous Endpoint with Known Variances}
\usage{
sim_Aa_optimal_known_var(
  Pats,
  nMax,
  TimeToOutcome,
  enrollrate,
  N2,
  armn,
  mean,
  sd,
  alphaa = 0.025,
  armlabel,
  side
)
}
\arguments{
\item{Pats}{the number of patients accrued within a certain time frame indicates the
count of individuals who have been affected by the disease during that specific period,
for example, a month or a day. If this number is 10, it represents that
10 people have got the disease within the specified time frame.}

\item{nMax}{the assumed maximum accrued number of patients with the disease in the population, this number
should be chosen carefully to ensure a sufficient number of patients are simulated,
especially when considering the delay mechanism.}

\item{TimeToOutcome}{the distribution of delayed response times or a fixed delay time for responses.
The delayed time could be a month, a week or any other time frame. When the unit changes,
the number of TimeToOutcome should also change. It can be in the format
of expression(rnorm( length( vStartTime ),30, 3)), representing delayed responses
with a normal distribution, where the mean is 30 days and the standard deviation is 3 days.}

\item{enrollrate}{probability that patients in the population can enroll in the trial.
This parameter is related to the number of people who have been affected by the disease in the population,
following an exponential distribution.}

\item{N2}{maximal sample size for the trial.}

\item{armn}{number of total arms in the trial.}

\item{mean}{a vector of hypotheses of mean for all arms in the trial,
with the first one serving as the control group.}

\item{sd}{a vector of hypotheses of standard deviation for allarms in the trial,
with the first one serving as the control group.}

\item{alphaa}{the overall type I error to be controlled for the one-sided test. Default value is set to 0.025.}

\item{armlabel}{a vector of arm labels with an example of c(1, 2), where 1 and 2 describes
how each arm is labeled in a two-armed trial.}

\item{side}{direction of a one-sided test, with values 'upper' or 'lower'.}
}
\value{
\code{sim_Aa_optimal_known_var} returns an object of class "Aaoptimal". An object of class "Aaoptimal" is a list containing 
final decision based on the Z test statistics with 1 stands for selected and 0 stands for not selected,
Z test statistics, the simulated data set and participants accrued for each arm at the time of termination of that group in one trial.
The simulated data set includes 5 columns: participant ID number, enrollment time, observed time of results,
allocated arm, and participants' result.
}
\description{
\code{sim_Aa_optimal_known_var} simulates a trial for continuous endpoints with known variances,
and the allocation probabilities are fixed.
}
\details{
This function aims to minimize the criteria \eqn{tr[A^TM^{-1}(\rho)A]}
and minimize the overall variance of pairwise comparisons. It is analogous to Neyman
allocation, favoring a higher allocation ratio to the control group. With more than two treatment 
groups the one-sided nominal level of each test is \code{alphaa} divided by \code{arm*(arm-1)/2}; a Bonferroni correction.
Considering the delay mechanism, \code{Pats} (the number of patients accrued within a certain time frame),
\code{nMax} (the assumed maximum accrued number of patients with the disease in the population) and 
\code{TimeToOutcome} (the distribution of delayed response times or a fixed delay time for responses) 
are parameters in the functions adapted from \url{https://github.com/kwathen/IntroBayesianSimulation}.
Refer to the website for more details.
}
\examples{
#Run the function with delayed responses follow a normal distribution with
#a mean of 30 days and a standard deviation of 3 days under null hypothesis
#in a two-armed trial
sim_Aa_optimal_known_var(Pats=10,nMax=50000,TimeToOutcome=expression(
rnorm(length( vStartTime ),30, 3)),enrollrate=0.9,N2=88,armn=2,
mean=c(9.1/100,9.1/100),sd=c(0.009,0.009),alphaa=0.025,armlabel = c(1,2),side='lower')

#Run the function with delayed responses follow a normal distribution with
#a mean of 30 days and a standard deviation of 3 days under alternative hypothesis
#in a two-armed trial
sim_Aa_optimal_known_var(Pats=10,nMax=50000,TimeToOutcome=expression(
rnorm(length( vStartTime ),30, 3)),enrollrate=0.9,N2=88,armn=2,
mean=c(9.1/100,8.47/100),sd=c(0.009,0.009),alphaa=0.025,armlabel = c(1,2),side='lower')
}
\references{
\insertRef{Oleksandr2013}{RARtrials}
}
