% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RAQSAPIlistfunctions.R
\name{aqs_parameters_by_class}
\alias{aqs_parameters_by_class}
\title{aqs_parameters_by_class}
\usage{
aqs_parameters_by_class(class, return_header = FALSE)
}
\arguments{
\item{class}{a R character object that represents the class requested,
@seealso \code{\link[=aqs_classes]{aqs_classes()}} for retrieving
available classes.  The class R character object must be a
valid class as returned from aqs_classes(). The class must
be an exact match to what is returned from aqs_classes().}

\item{return_header}{If FALSE (default) only returns data requested.
If TRUE returns a AQSAPI_v2 object which is a two
item list that contains header information returned
from the API server mostly used for debugging
purposes in addition to the data requested.}
}
\value{
a tibble or an AQS_Data Mart_APIv2 S3 object containing the
parameters associated with the class requested. NULL is returned
for classes not found.
}
\description{
\lifecycle{stable}
Returns parameters associated with the input class.
}
\examples{
# Returns a tibble of AQS parameters in the criteria class
          \dontrun{ aqs_parameters_by_class(class = "CRITERIA") }
}
