% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AQSAPI.R
\name{aqs_counties_by_state}
\alias{aqs_counties_by_state}
\title{aqs_counties_by_state}
\usage{
aqs_counties_by_state(stateFIPS, return_header = FALSE)
}
\arguments{
\item{stateFIPS}{a R character object which represents the 2 digit state
FIPS code (with leading zeros) for the state being
requested. @seealso \code{\link[=aqs_states]{aqs_states()}} for the list of
available FIPS codes.}

\item{return_header}{If FALSE (default) only returns data requested.
If TRUE returns a AQSAPI_v2 object which is a two
item list that contains header information returned
from the API server mostly used for debugging
purposes in addition to the data requested.}
}
\value{
a tibble or an AQS_Data Mart_APIv2 S3 object of all counties in the
requested state.
}
\description{
\lifecycle{stable}
Returns a table of all counties in within the
stateFIPS provided.
}
\examples{
          #returns an tibble all the counties
          #   in North Carolina the county FIPS codes (county codes) for
          #   each.
          \dontrun{aqs_counties_by_state(stateFIPS = "37")}
}
