% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export.msfinder.formulas.R
\name{export.msfinder.formulas}
\alias{export.msfinder.formulas}
\title{export MSFinder formula prediction results in tabular format.}
\usage{
export.msfinder.formulas(ramclustObj = NULL, export.all = FALSE,
  output.directory = NULL)
}
\arguments{
\item{ramclustObj}{R object - the ramclustR object which was used to write the .mat or .msp files}

\item{export.all}{logical: default = FALSE.  If TRUE, export all columns, if FALSE, only columns 1: "exactmass"}

\item{output.directory}{valid path: default = NULL.  If NULL, results are exported to spectra/mat directory.}
}
\value{
an updated ramclustR object, with the RC$ann and RC$ann.conf slots updated to annotated based on output from 1. ramsearch output, 2. msfinder mssearch, 3. msfinder predicted structure, 4. msfinder predicted formula, and 5. interpretMSSpectrum inferred molecular weight, with listed order as priority.
}
\description{
After running MSFinder, results have been imported to the ramclustR object.  This function exports as a .csv file for ease of viewing.
}
\details{
this function exports a .csv file containing all returned MSFinder molecular formula hypotheses. this file is saved (by default) to the working directory spectra/mat/ directory
}
\references{
Broeckling CD, Afsar FA, Neumann S, Ben-Hur A, Prenni JE. RAMClust: a novel feature clustering method enables spectral-matching-based annotation for metabolomics data. Anal Chem. 2014 Jul 15;86(14):6812-7. doi: 10.1021/ac501530d.  Epub 2014 Jun 26. PubMed PMID: 24927477.

Broeckling CD, Ganna A, Layer M, Brown K, Sutton B, Ingelsson E, Peers G, Prenni JE. Enabling Efficient and Confident Annotation of LC-MS Metabolomics Data through MS1 Spectrum and Time Prediction. Anal Chem. 2016 Sep 20;88(18):9226-34. doi: 10.1021/acs.analchem.6b02479. Epub 2016 Sep 8. PubMed PMID: 7560453.

Tsugawa H, Kind T, Nakabayashi R, Yukihira D, Tanaka W, Cajka T, Saito K, Fiehn O, Arita M. Hydrogen Rearrangement Rules: Computational MS/MS Fragmentation and Structure Elucidation Using MS-FINDER Software. Anal Chem. 2016 Aug 16;88(16):7946-58. doi: 10.1021/acs.analchem.6b00770. Epub 2016 Aug 4. PubMed PMID: 27419259.
}
\author{
Corey Broeckling
}
\keyword{'MSFinder'}
\keyword{'RAMClustR',}
\keyword{'mass}
\keyword{'metabolomics',}
\keyword{'molecular}
\keyword{'ramclustR'}
\keyword{formula',}
\keyword{spectrometry',}
