% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/other_useful_functions.R
\name{estPhylo}
\alias{estPhylo}
\title{Function to estimate & plot phylogenetic tree}
\usage{
estPhylo(
  blockInterest = NULL,
  gwasRes = NULL,
  nTopRes = 1,
  gene.set = NULL,
  indexRegion = 1:10,
  chrInterest = NULL,
  posRegion = NULL,
  blockName = NULL,
  pheno = NULL,
  geno = NULL,
  ZETA = NULL,
  chi2Test = TRUE,
  thresChi2Test = 0.05,
  plotTree = TRUE,
  distMat = NULL,
  distMethod = "manhattan",
  evolutionDist = FALSE,
  subpopInfo = NULL,
  groupingMethod = "kmedoids",
  nGrp = 4,
  nIterClustering = 100,
  kernelType = "A.mat",
  saveName = NULL,
  saveStyle = "png",
  pchBase = c(1, 16),
  colNodeBase = c(2, 4),
  colTipBase = c(3, 5, 6, 7),
  cexMax = 2,
  edgeColoring = TRUE,
  tipLabel = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{blockInterest}{A \eqn{n \times M} matrix representing the marker genotype that belongs to the haplotype block of interest.
If this argument is NULL, this argument will automatically be determined by `geno`,}

\item{gwasRes}{You can use the results (data.frame) of haplotype-based (SNP-set) GWAS by `RGWAS.multisnp` function.}

\item{nTopRes}{Haplotype blocks (or gene sets, SNP-sets) with top `nTopRes` p-values by `gwasRes` will be used.}

\item{gene.set}{If you have information of gene (or haplotype block), you can use it to perform kernel-based GWAS.
You should assign your gene information to gene.set in the form of a "data.frame" (whose dimension is (the number of gene) x 2).
In the first column, you should assign the gene name. And in the second column, you should assign the names of each marker,
which correspond to the marker names of "geno" argument.}

\item{indexRegion}{You can specify the haplotype block (or gene set, SNP-set) of interest by the marker index in `geno`.}

\item{chrInterest}{You can specify the haplotype block (or gene set, SNP-set) of interest by the marker position in `geno`.
Please assign the chromosome number to this argument.}

\item{posRegion}{You can specify the haplotype block (or gene set, SNP-set) of interest by the marker position in `geno`.
Please assign the position in the chromosome to this argument.}

\item{blockName}{You can specify the haplotype block (or gene set, SNP-set) of interest by the name of haplotype block in `geno`.}

\item{pheno}{Data frame where the first column is the line name (gid). 
The remaining columns should be a phenotype to test.}

\item{geno}{Data frame with the marker names in the first column. The second and third columns contain the chromosome and map position.
Columns 4 and higher contain the marker scores for each line, coded as {-1, 0, 1} = {aa, Aa, AA}.}

\item{ZETA}{A list of covariance (relationship) matrix (K: \eqn{m \times m}) and its design matrix (Z: \eqn{n \times m}) of random effects.
Please set names of list "Z" and "K"! You can use more than one kernel matrix.
For example,

ZETA = list(A = list(Z = Z.A, K = K.A), D = list(Z = Z.D, K = K.D))
\describe{
\item{Z.A, Z.D}{Design matrix (\eqn{n \times m}) for the random effects. So, in many cases, you can use the identity matrix.}
\item{K.A, K.D}{Different kernels which express some relationships between lines.}
}
For example, K.A is additive relationship matrix for the covariance between lines, and K.D is dominance relationship matrix.}

\item{chi2Test}{If TRUE, chi-square test for the relationship between haplotypes & subpopulations will be performed.}

\item{thresChi2Test}{The threshold for the chi-square test.}

\item{plotTree}{If TRUE, the function will return the plot of phylogenetic tree.}

\item{distMat}{You can assign the distance matrix of the block of interest. 
If NULL, the distance matrix will be computed in this function.}

\item{distMethod}{You can choose the method to calculate distance between accessions.
This argument corresponds to the `method` argument in the `dist` function.}

\item{evolutionDist}{If TRUE, the evolution distance will be used instead of the pure distance.
The `distMat` will be converted to the distance matrix by the evolution distance.}

\item{subpopInfo}{The information of subpopulations. This argument should be a vector of factor.}

\item{groupingMethod}{If `subpopInfo` argument is NULL, this function estimates subpopulation information from marker genotype.
You can choose the grouping method from `kmeans`, `kmedoids`, and `hclust`.}

\item{nGrp}{The number of groups (or subpopulations) grouped by `groupingMethod`.
If this argument is 0, the subpopulation information will not be estimated.}

\item{nIterClustering}{If `groupingMethod` = `kmeans`, the clustering will be performed multiple times.
This argument specifies the number of classification performed by the function.}

\item{kernelType}{In the function, similarlity matrix between accessions will be computed from marker genotype to estimate genotypic values.
This argument specifies the method to compute similarility matrix: 
If this argument is `A.mat`, then the `A.mat` function in the `rrBLUP` package will be used,
and if this argument is `dist`, the gaussian kernel will be computed from marker genotype.}

\item{saveName}{When drawing any plot, you can save plots in png format. In saveName, you should substitute the name you want to save.
When saveName = NULL, the plot is not saved.}

\item{saveStyle}{This argument specifies how to save the plot of phylogenetic tree.
The function offers `png`, `pdf`, `jpg`, and `tiff`.}

\item{pchBase}{A vector of two integers specifying the plot types for the positive and negative genotypic values respectively.}

\item{colNodeBase}{A vector of two integers or chracters specifying color of nodes for the positive and negative genotypic values respectively.}

\item{colTipBase}{A vector of integers or chracters specifying color of tips for the positive and negative genotypic values respectively.
The length of the vector should equal to the number of subpopulations.}

\item{cexMax}{A numeric specifying the point size of the plot.}

\item{edgeColoring}{If TRUE, the edge branch of phylogenetic tree wiil be colored.}

\item{tipLabel}{If TRUE, lavels for tips will be shown.}

\item{verbose}{If this argument is TRUE, messages for the current steps will be shown.}
}
\value{
\describe{A List of 
\item{$haplotypeInfo}{\describe{A List of haplotype information with 
\item{$haploCluster}{A vector indicating each individual belongs to which haplotypes.}
\item{$haploBlock}{Marker genotype of haplotype block of interest for the representing haplotypes.}
}
}
\item{$pValChi2Test}{A p-value of the chi-square test for the dependency between haplotypes & subpopulations.
If `chi2Test = FALSE`, `NA` will be returned.}
\item{$gvTotal}{Estimated genotypic values by Gaussian kernel regression for each individuals.}
\item{$minuslog10p}{\eqn{-log_{10}(p)} for haplotype block of interest.
 p is the p-value for the siginifacance of the haplotype block effect.}
}
}
\description{
Function to estimate & plot phylogenetic tree
}
