% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_for_RGWAS.R
\name{manhattan}
\alias{manhattan}
\title{Draw manhattan plot}
\usage{
manhattan(input, sig.level = 0.05, method.thres = "BH", y.max = NULL,
  cex.lab = 1, lwd.thres = 1, plot.col1 = c("dark blue",
  "cornflowerblue"), cex.axis.x = 1, cex.axis.y = 1, plot.type = "p",
  plot.pch = 16)
}
\arguments{
\item{input}{Data frame of GWAS results where the first column is the marker names,
the second and third column is the chromosome amd map position, and the forth column is -log10(p) for each marker.}

\item{sig.level}{Significance level for the threshold. The default is 0.05.}

\item{method.thres}{Method for detemining threshold of significance. "BH" and "Bonferroni are offered.}

\item{y.max}{The maximum value for the vertical axis of manhattan plot. If NULL, automatically determined.}

\item{cex.lab}{The font size of the labels.}

\item{lwd.thres}{The line width for the threshold.}

\item{plot.col1}{This argument determines the color of the manhattan plot.
You should substitute this argument as color vector whose length is 2.
plot.col1[1] for odd chromosomes and plot.col1[2] for even chromosomes.}

\item{cex.axis.x}{The font size of the x axis.}

\item{cex.axis.y}{The font size of the y axis.}

\item{plot.type}{This argument determines the type of the manhattan plot. See the help page of "plot".}

\item{plot.pch}{This argument determines the shape of the dot of the manhattan plot. See the help page of "plot".}
}
\value{
Draw manhttan plot
}
\description{
Draw manhattan plot
}
