% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test3Gsr.R
\name{test3Gsr}
\alias{test3Gsr}
\title{Test3G.SR}
\usage{
test3Gsr(X, freq, verbose = TRUE, rounding = 3)
}
\arguments{
\item{X}{is a matrix of encounter histories with K occasions}

\item{freq}{is a vector of the number of individuals with the corresponding encounter history}

\item{verbose}{controls the level of the details in the outputs; default is TRUE for all details}

\item{rounding}{is the level of rounding for outputs; default is 3}
}
\value{
This function returns a list with first component the overall test and second component a data.frame with occasion, site, the value of the test statistic, degree of freedom, p-value and test performed (chi-square, Fisher or none).
}
\description{
This function performs Test3G.SR
}
\examples{
# Read in Geese dataset:
geese = system.file("extdata", "geese.inp", package = "R2ucare")
geese = read_inp(geese)

# Get encounter histories and number of individuals with corresponding histories
geese.hist = geese$encounter_histories
geese.freq = geese$sample_size

# perform Test3.GSR
test3Gsr(geese.hist,geese.freq)
}
\author{
Olivier Gimenez <olivier.gimenez@cefe.cnrs.fr>, Rémi Choquet, Roger Pradel
}
\keyword{package}

