\name{svg2swf}
\alias{svg2swf}
\title{Convert a sequence of SVG files to SWF file}
\usage{
svg2swf(input, output = "./movie.swf", bgColor = "white", 
    interval = 1)
}
\arguments{
  \item{input}{the file names of the SVG files to be
  converted}

  \item{output}{the name of the output SWF file}

  \item{bgColor}{background color of the output SWF file}

  \item{interval}{the time interval (in seconds) between
  animation frames}
}
\value{
  The path of the generated SWF file if successful.
}
\description{
  Given the file names of a sequence of SVG files, this
  function could convert them into a Flash file (.swf).
}
\details{
  This function uses the XML package in R and a subset of
  librsvg (\url{http://librsvg.sourceforge.net/}) to parse
  the SVG file, and utilize the Ming library
  (\url{http://www.libming.org/}) to implement the
  conversion. Currently the support for SVG file is
  \strong{NOT} perfect and \strong{ONLY} support files
  generated by \code{\link[Cairo]{CairoSVG}()} in the
  \pkg{Cairo} package.
}
\note{
  Currently there is no function in R that could
  auto-generate a sequence of SVG files, so you may create
  the them once at a time. See the example.
}
\examples{
\dontrun{
if (require("Cairo")) {
    olddir = setwd(tempdir())
    filenames = sprintf("Rplot\%03d.svg", 1:9)
    for (fn in filenames) {
        CairoSVG(fn)
        plot(runif(20), ylim = c(0, 1))
        dev.off()
    }
    output = svg2swf(filenames, bgColor = "steelblue")
    swf2html(output)
    setwd(olddir)
}
}
}
\author{
  Yixuan Qiu <\email{yixuan.qiu@cos.name}>
}
