% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funcDT.R
\name{lowFreqLevel2MissingDT}
\alias{lowFreqLevel2MissingDT}
\title{Transform levels of all the factor columns of a data.table object to missing if too little observations pertain to a given level of it.}
\usage{
lowFreqLevel2MissingDT(inputDT, minNumberLevel = NULL)
}
\arguments{
\item{inputDT}{data.table object containing the data of interest. This is an obligatory argument, without default value.}

\item{minNumberLevel}{Numeric vector of length 1 that indicates the minimal number of observations of a given level that should be observed to avoid that that level will be deleted from the list of possible levels for that factor and the value of its observations will be turned into missing values.}
}
\value{
No value is returned. The level that was not underpopulated is also removed from the levels of the respective categorical variable.
}
\description{
Transform levels of all the factor columns of a data.table object to missing if too little observations pertain to a given level of it.
}
\examples{
library(data.table)
inputDT <- as.data.table(data.frame(x = seq(1, 20, 2), y = LETTERS[1:10]))
levels(inputDT$y)
lowFreqLevel2MissingDT(inputDT, 2)
levels(inputDT$y)

inputDT <- as.data.table(data.frame(x = seq(1, 40, 2),
y = c(LETTERS[1:10], LETTERS[1:10])))
levels(inputDT$y)
lowFreqLevel2MissingDT(inputDT, 1)
levels(inputDT$y)
}
