\name{est.GT}
\alias{est.GT}
\title{Find the best-fitting GT distribution for a series of serial interval}
\description{Find the best-fitting GT distribution for a series of serial interval}
\usage{est.GT(infector.onset.dates = NULL, infectee.onset.dates = NULL, 
    serial.interval = NULL, request.plot = FALSE, ...)}
\arguments{
  \item{infector.onset.dates}{Vector of dates for infector symptoms onset.}
  \item{infectee.onset.dates}{Vector of dates for infectee symptoms onset.}
  \item{serial.interval}{Vector of reported serial interval.}
  \item{request.plot}{Should data adjsument be displayed at the end?}
  \item{\dots}{Parameters passed to other functions (useful for hidden parameters of \code{\link{generation.time}})}
}
\details{Generation Time distribution can be estimated by two inputs methods.
User can either provide two vectors of dates or a unique vector of reported serial intervals.
If two vectors are provided, both onset.dates vectors should be of same length. Element i is the onset date for individual i. This means that infector k (symptoms on day infector.onset.dates[k]) infected infectee k (symptoms on day infectee.onset.dates[k])
If only serial.interval is provided, each record is assumed to be the time elapsed between each pair of infector and infectee.

When request.plot is set to TRUE, a graphical output provides standardized histogram of observed data along with
the best-fitting adjusted model.}
\value{A R0.GT object that complies with generation time distribution requirements of the R0 package.}

\author{Pierre-Yves Boelle, Thomas Obadia}




\examples{#Loading package
library(R0)

# Data taken from traced cases of H1N1 viruses.
data(H1N1.serial.interval)
est.GT(serial.interval=H1N1.serial.interval)

## Best fitting GT distribution is a gamma distribution with mean = 3.039437 and sd = 1.676551 .
## Discretized Generation Time distribution
## mean: 3.070303 , sd: 1.676531 
## [1] 0.0000000000 0.1621208802 0.2704857362 0.2358751176 0.1561845680 0.0888997193 0.0459909903 
## 0.0222778094 0.0102848887 0.0045773285 0.0019791984 0.0008360608 0.0003464431 0.0001412594


# The same result can be achieved with two vectors of dates of onset.
# Here we use the same data, but trick the function into thinking onset dates are all "0".
data(H1N1.serial.interval)
est.GT(infector.onset.dates=rep(0,length(H1N1.serial.interval)), 
       infectee.onset.dates=H1N1.serial.interval)}
