%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Do not modify this file since it was automatically generated from:
% 
%  abort.R
% 
% by the Rdoc compiler part of the R.oo package.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\name{abort}
\alias{abort.default}
\alias{abort}
\alias{abort.condition}

\title{Aborts the current expression call}

\description{
 Aborts the current expression call and returns to the top level prompt/browser
 \emph{without signalling a condition}.
}

\usage{\method{abort}{default}(..., call.=TRUE, domain=NULL)}

\arguments{
  \item{...}{(optional) Objects coerced to \code{\link[base]{character}} and pasted together without a separator, or a @condition object. If no object are given, no message is printed.}
  \item{call.}{If \code{\link[base:logical]{TRUE}}, the call is added to the message, otherwise not.}
  \item{domain}{Used to translate the message (see \code{\link[base]{gettext}}()). If \code{\link[base]{NA}}, messages will not be translated.}
}

\value{
  Returns nothing.
}

\details{
  There are still cases where one can "catch" the abort and undo it, cf. [1].
}

\examples{\dontrun{
 foo <- function() {
  cat("foo()...\n")
  on.exit(cat("foo()...done\n"))
  tryCatch({
    stop("Woops!")
  }, error = function(ex) {
    cat("An error was caught: ", ex$message, "\n", sep="")
  })
  cat("Continuing...\n")
}

bar <- function() {
  cat("bar()...\n")
  on.exit(cat("bar()...done\n"))
  tryCatch({
    abort("Woops!")
  }, error = function(ex) {
    cat("An error was caught: ", ex$message, "\n", sep="")
  })
  cat("This message will never be displayed...\n")
}

# An error generated by stop() can be caught
foo()

# ...which is not possible when using abort()
bar()

# This expression is never reached
cat("This line will never be outputted.\n")

}}

\author{Henrik Bengtsson (\url{http://www.braju.com/R/})}

\seealso{
  \code{\link{throw}}().
  \code{\link[base]{stop}}().
  Internally, \code{\link[base]{invokeRestart}}()\code{("abort")} is utilized.
}

\references{
  [1] R-devel thread '', Sept 11, 2012,
  \url{https://stat.ethz.ch/pipermail/r-devel/2012-September/064838.html}.\cr
}



\keyword{error}
\keyword{internal}
